/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aesh.extensions.text.highlight.Theme;
import org.jboss.aesh.extensions.text.highlight.TokenType;

public interface Encoder {
    public void textToken(String var1, TokenType var2);

    public void beginGroup(TokenType var1);

    public void endGroup(TokenType var1);

    public void beginLine(TokenType var1);

    public void endLine(TokenType var1);

    public static class Factory {
        private static Factory factory;
        private Map<String, Class<? extends Encoder>> registry = new HashMap<String, Class<? extends Encoder>>();

        private Factory() {
        }

        private static Factory instance() {
            if (factory == null) {
                factory = new Factory();
            }
            return factory;
        }

        public static void registrer(String type, Class<? extends Encoder> encoder) {
            Factory.instance().registry.put(type, encoder);
        }

        public static Encoder create(String type, OutputStream out, Theme theme, Map<String, Object> options) {
            Class<? extends Encoder> encoder = Factory.instance().registry.get(type);
            if (encoder != null) {
                try {
                    Constructor<? extends Encoder> constructor = encoder.getConstructor(OutputStream.class, Theme.class, Map.class);
                    return constructor.newInstance(out, theme, options);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create new instance of " + encoder);
                }
            }
            throw new RuntimeException("No encoder found for type " + type);
        }
    }

    public static abstract class AbstractEncoder
    implements Encoder {
        public static final String NEW_LINE = System.getProperty("line.separator");
        protected OutputStream out;
        protected Theme theme;
        protected Map<String, Object> options;

        public AbstractEncoder(OutputStream out, Theme theme, Map<String, Object> options) {
            this.out = out;
            this.theme = theme;
            this.options = options;
        }

        protected Color color(TokenType type) {
            return this.theme.lookup(type);
        }

        protected void write(String str) {
            try {
                this.out.write(str.getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write to output", e);
            }
        }

        protected void write(byte[] bytes) {
            try {
                this.out.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write to output", e);
            }
        }
    }

    public static enum Type {
        TERMINAL,
        DEBUG;

    }
}

