/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.simple.lifecycle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.Service;
import org.jboss.forge.furnace.container.simple.SingletonService;
import org.jboss.forge.furnace.container.simple.events.SimpleEventManagerImpl;
import org.jboss.forge.furnace.container.simple.impl.SimpleServiceRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.lifecycle.AddonLifecycleProvider;
import org.jboss.forge.furnace.lifecycle.ControlType;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.ClassLoaders;

public class SimpleContainerImpl
implements AddonLifecycleProvider {
    private static final Logger log = Logger.getLogger(SimpleContainerImpl.class.getName());
    private Furnace furnace;

    public void initialize(Furnace furnace, AddonRegistry registry, Addon self) throws Exception {
        this.furnace = furnace;
    }

    public void start(Addon addon) throws Exception {
        SimpleContainer.start((Addon)addon, (Furnace)this.furnace);
    }

    public void stop(Addon addon) throws Exception {
        SimpleContainer.stop((Addon)addon);
    }

    public EventManager getEventManager(Addon addon) {
        return new SimpleEventManagerImpl(addon);
    }

    public ServiceRegistry getServiceRegistry(Addon addon) throws Exception {
        Set<Class<?>> serviceTypes = this.locateServices(addon, Service.class);
        Set<Class<?>> singletonServiceTypes = this.locateServices(addon, SingletonService.class);
        return new SimpleServiceRegistry(this.furnace, addon, serviceTypes, singletonServiceTypes);
    }

    private Set<Class<?>> locateServices(Addon addon, Class<?> serviceType) throws IOException {
        URL resource = addon.getClassLoader().getResource("/META-INF/services/" + serviceType.getName());
        HashSet serviceTypes = new HashSet();
        if (resource != null) {
            try (InputStream stream = resource.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String serviceName;
                while ((serviceName = reader.readLine()) != null) {
                    if (ClassLoaders.containsClass((ClassLoader)addon.getClassLoader(), (String)serviceName)) {
                        Class type = ClassLoaders.loadClass((ClassLoader)addon.getClassLoader(), (String)serviceName);
                        if (!ClassLoaders.ownsClass((ClassLoader)addon.getClassLoader(), (Class)type)) continue;
                        serviceTypes.add(type);
                        continue;
                    }
                    log.log(Level.WARNING, "Service class not enabled due to underlying classloading error. If this is unexpected, enable DEBUG logging to see the full stack trace: " + this.getClassLoadingErrorMessage(addon, serviceName));
                    log.log(Level.FINE, "Service class not enabled due to underlying classloading error.", ClassLoaders.getClassLoadingExceptionFor((ClassLoader)addon.getClassLoader(), (String)serviceName));
                }
            }
        }
        return serviceTypes;
    }

    private String getClassLoadingErrorMessage(Addon addon, String serviceType) {
        Throwable e;
        for (e = ClassLoaders.getClassLoadingExceptionFor((ClassLoader)addon.getClassLoader(), (String)serviceType); e.getCause() != null && e.getCause() != e; e = e.getCause()) {
        }
        return e.getClass().getName() + ": " + e.getMessage();
    }

    public void postStartup(Addon addon) throws Exception {
        this.getEventManager(addon).fireEvent((Object)new PostStartup(addon), new Annotation[0]);
    }

    public void preShutdown(Addon addon) throws Exception {
        this.getEventManager(addon).fireEvent((Object)new PreShutdown(addon), new Annotation[0]);
    }

    public ControlType getControlType() {
        return ControlType.DEPENDENTS;
    }
}

