/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.oupls.sail.pg.PropertyGraphSail;
import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import info.aduna.iteration.CloseableIteration;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.renderer.AbstractGraphRenderer;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.sail.SailConnection;

public class GraphRDFRenderer
extends AbstractGraphRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderGraph(GraphContext context) {
        try {
            WindupConfigurationModel configuration = GraphService.getConfigurationModel((GraphContext)context);
            Path outputFolder = this.createOutputFolder(configuration, "rdf");
            Path outputFile = outputFolder.resolve("graph.rdf");
            EventGraph graph = context.getGraph();
            PropertyGraphSail sail = new PropertyGraphSail((Graph)graph);
            sail.initialize();
            FileOutputStream fos = new FileOutputStream(outputFile.toFile());
            RDFWriter writer = Rio.createWriter((RDFFormat)RDFFormat.NTRIPLES, (OutputStream)fos);
            writer.startRDF();
            try (SailConnection sc = null;){
                sc = sail.getConnection();
                try (CloseableIteration n = sc.getNamespaces();){
                    while (n.hasNext()) {
                        Namespace ns = (Namespace)n.next();
                        writer.handleNamespace(ns.getPrefix(), ns.getName());
                    }
                }
                try (CloseableIteration i = sc.getStatements(null, null, null, false, new Resource[0]);){
                    while (i.hasNext()) {
                        Statement stmt = (Statement)i.next();
                        if (stmt.getSubject() == null || stmt.getPredicate() == null || stmt.getObject() == null) continue;
                        writer.handleStatement(stmt);
                    }
                }
            }
            writer.endRDF();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

