/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer.gexf;

import com.tinkerpop.blueprints.Graph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.windup.reporting.renderer.GraphWriter;
import org.jboss.windup.reporting.renderer.gexf.GexfWriter;
import org.joox.JOOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SigmaJSHtmlWriter
implements GraphWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SigmaJSHtmlWriter.class);
    private final GexfWriter gexfWriter;

    public SigmaJSHtmlWriter(Graph graph) {
        this.gexfWriter = new GexfWriter(graph, "static", "directed", "qualifiedName", "");
    }

    public SigmaJSHtmlWriter(Graph graph, String vertexLabelProperty, String edgeLabel) {
        this.gexfWriter = new GexfWriter(graph, "static", "directed", vertexLabelProperty, edgeLabel);
    }

    @Override
    public void writeGraph(OutputStream os) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("sigmajs/HtmlTemplate.html");
        String result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.gexfWriter.writeGraph(baos);
        result = baos.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("GEXF: " + result);
        }
        try {
            Document document = JOOX.$((InputStream)is).document();
            JOOX.$((Document)document).find("#gexf-source").append(result);
            this.writeDocument(document, os);
        }
        catch (SAXException e) {
            throw new IOException("Exception loading document.", e);
        }
    }

    public void writeDocument(Document document, OutputStream os) throws IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Exception writing to output stream.", e);
        }
    }
}

