/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.rep.elections.Acceptor;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import java.net.InetSocketAddress;

public class MasterSuggestionGenerator
implements Acceptor.SuggestionGenerator {
    private final RepNode repNode;
    private boolean forceAsMaster = false;
    private static final long PREMPTIVE_RANKING = Long.MAX_VALUE;
    private static final long MASTER_RANKING = 0x7FFFFFFFFFFFFFFEL;

    public MasterSuggestionGenerator(RepNode repNode) {
        this.repNode = repNode;
    }

    public Protocol.Value get(Proposer.Proposal proposal) {
        InetSocketAddress socket = this.repNode.getSocket();
        return new MasterValue(socket.getAddress().getHostAddress(), socket.getPort(), this.repNode.getNameIdPair());
    }

    public long getRanking(Proposer.Proposal proposal) {
        if (this.forceAsMaster) {
            return Long.MAX_VALUE;
        }
        this.repNode.getVLSNFreezeLatch().freeze(proposal);
        if (this.repNode.isAuthoritativeMaster()) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        return this.repNode.getVLSNIndex().getRange().getLast().getSequence();
    }

    public void forceMaster(boolean force) {
        this.forceAsMaster = force;
    }
}

