/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.operation.xslt;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.util.ClassLoaders;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.FileReferenceModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.model.XsltTransformationModel;
import org.jboss.windup.rules.apps.xml.operation.xslt.XSLTTransformationOf;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLTTransformation
extends AbstractIterationOperation<XmlFileModel> {
    private ClassLoader contextClassLoader;
    @Inject
    GraphApiCompositeClassLoaderProvider compositeClassLoader;
    private static final Logger LOG = LoggerFactory.getLogger(XSLTTransformation.class);
    private String description;
    private String location;
    private String extension;
    private Transformer xsltTransformer;
    private Map<String, String> xsltParameters;

    XSLTTransformation(String variable) {
        super(variable);
    }

    XSLTTransformation() {
    }

    public void perform(GraphRewrite event, EvaluationContext context) {
        this.checkVariableName(event, context);
        WindupVertexFrame payload = this.resolveVariable(event, this.getVariableName());
        if (payload instanceof FileReferenceModel) {
            FileModel file = ((FileReferenceModel)payload).getFile();
            this.perform(event, context, (XmlFileModel)file);
        } else {
            super.perform(event, context);
        }
    }

    public static XSLTTransformationOf of(String variable) {
        return new XSLTTransformationOf(variable);
    }

    public XSLTTransformation withDescription(String description) {
        this.description = description;
        return this;
    }

    public void setSourceLocation(String location) {
        this.location = location;
    }

    public XSLTTransformation withExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public static XSLTTransformation using(String location) {
        XSLTTransformation tansformation = new XSLTTransformation();
        tansformation.contextClassLoader = Thread.currentThread().getContextClassLoader();
        tansformation.location = location;
        return tansformation;
    }

    public void setup() {
        try (InputStream resourceAsStream = this.contextClassLoader.getResourceAsStream(this.location);){
            final StreamSource xsltSource = new StreamSource(resourceAsStream);
            final TransformerFactory tf = TransformerFactory.newInstance();
            tf.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    if (StringUtils.contains((String)href, (String)"http://")) {
                        LOG.warn("Trying to fetch remote URL for XSLT.  This is not possible; for speed reasons: " + href + ": " + base);
                        return null;
                    }
                    return new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(href));
                }
            });
            ClassLoaders.executeIn((ClassLoader)TransformerFactory.class.getClassLoader(), (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    XSLTTransformation.this.xsltTransformer = tf.newTransformer(xsltSource);
                    return null;
                }
            });
            if (this.xsltParameters != null) {
                for (String key : this.xsltParameters.keySet()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Setting property: " + key + " -> " + this.xsltParameters.get(key));
                    }
                    this.xsltTransformer.setParameter(key, this.xsltParameters.get(key));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created XSLT successfully: " + this.location);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Problem working with xsl file located at " + this.location + ". Please check if the file really exists.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Not able to initialize the XSLT transformer.", e);
        }
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        this.setup();
        GraphContext graphContext = event.getGraphContext();
        GraphService transformationService = new GraphService(graphContext, XsltTransformationModel.class);
        String relativeDirectory = StringUtils.substringBeforeLast((String)payload.getFilePath(), (String)File.separator);
        String fileName = StringUtils.substringAfterLast((String)payload.getFilePath(), (String)File.separator);
        fileName = StringUtils.replace((String)fileName, (String)".", (String)"-");
        fileName = fileName + this.extension;
        File resultFile = new File(relativeDirectory + File.separator + fileName);
        DOMSource xmlSource = new DOMSource(payload.asDocument());
        StreamResult xmlResult = new StreamResult(resultFile);
        try {
            this.xsltTransformer.transform(xmlSource, xmlResult);
            XsltTransformationModel transformation = (XsltTransformationModel)transformationService.create();
            transformation.setDescription(this.description);
            transformation.setExtension(this.extension);
            transformation.setSourceLocation(this.location);
            transformation.setSourceFile(payload);
            transformation.setResult(resultFile.getAbsolutePath());
        }
        catch (TransformerException e) {
            LOG.error("Exception transforming XML.", (Throwable)e);
        }
    }
}

