/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.util.ArrayList;
import org.jboss.windup.graph.model.PackageModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;

@TypeValue(value="WindupConfiguration")
public interface WindupConfigurationModel
extends WindupVertexFrame {
    public static final String USER_RULES_PATH = "userRulesPath";
    public static final String PROPERTY_SOURCE_MODE = "sourceMode";
    public static final String PROPERTY_FETCH_REMOTE_RESOURCES = "fetchRemoteResources";
    public static final String PROPERTY_EXCLUDE_JAVA_PACKAGES = "excludeJavaPackages";
    public static final String PROPERTY_SCAN_JAVA_PACKAGES = "scanJavaPackages";

    @JavaHandler
    public void setInputPath(String var1);

    @Adjacency(label="inputPath", direction=Direction.OUT)
    public FileModel getInputPath();

    @Adjacency(label="inputPath", direction=Direction.OUT)
    public void setInputPath(FileModel var1);

    @Property(value="userRulesPath")
    public void setUserRulesPath(String var1);

    @Property(value="userRulesPath")
    public String getUserRulesPath();

    @JavaHandler
    public void setOutputPath(String var1);

    @Adjacency(label="outputPath", direction=Direction.OUT)
    public FileModel getOutputPath();

    @Adjacency(label="outputPath", direction=Direction.OUT)
    public void setOutputPath(FileModel var1);

    @Adjacency(label="scanJavaPackages", direction=Direction.OUT)
    public Iterable<PackageModel> getScanJavaPackages();

    @Adjacency(label="scanJavaPackages", direction=Direction.OUT)
    public void addScanJavaPackages(PackageModel var1);

    @Adjacency(label="scanJavaPackages", direction=Direction.OUT)
    public void setScanJavaPackages(Iterable<PackageModel> var1);

    @Adjacency(label="excludeJavaPackages", direction=Direction.OUT)
    public Iterable<PackageModel> getExcludeJavaPackages();

    @Adjacency(label="excludeJavaPackages", direction=Direction.OUT)
    public void addExcludeJavaPackage(PackageModel var1);

    @Adjacency(label="excludeJavaPackages", direction=Direction.OUT)
    public void setExcludeJavaPackages(Iterable<PackageModel> var1);

    @JavaHandler
    public void setScanJavaPackageList(Iterable<String> var1);

    @JavaHandler
    public void setExcludeJavaPackageList(Iterable<String> var1);

    @Property(value="fetchRemoteResources")
    public boolean isFetchRemoteResources();

    @Property(value="fetchRemoteResources")
    public void setFetchRemoteResources(boolean var1);

    @Property(value="sourceMode")
    public boolean isSourceMode();

    @Property(value="sourceMode")
    public void setSourceMode(boolean var1);

    public static abstract class Impl
    implements WindupConfigurationModel,
    JavaHandlerContext<Vertex> {
        @Override
        public void setInputPath(String inputPath) {
            FileModel fileModel = (FileModel)this.g().addVertex(null, FileModel.class);
            fileModel.setFilePath(inputPath);
            this.setInputPath(fileModel);
        }

        @Override
        public void setOutputPath(String outputPath) {
            FileModel fileModel = (FileModel)this.g().addVertex(null, FileModel.class);
            fileModel.setFilePath(outputPath);
            this.setOutputPath(fileModel);
        }

        @Override
        public void setScanJavaPackageList(Iterable<String> pkgs) {
            this.setScanJavaPackages(new ArrayList<PackageModel>());
            if (pkgs == null) {
                return;
            }
            for (String pkg : pkgs) {
                PackageModel m = (PackageModel)this.g().addVertex(null, PackageModel.class);
                m.setPackageName(pkg);
                this.addScanJavaPackages(m);
            }
        }

        @Override
        public void setExcludeJavaPackageList(Iterable<String> pkgs) {
            this.setExcludeJavaPackages(new ArrayList<PackageModel>());
            if (pkgs == null) {
                return;
            }
            for (String pkg : pkgs) {
                PackageModel m = (PackageModel)this.g().addVertex(null, PackageModel.class);
                m.setPackageName(pkg);
                this.addExcludeJavaPackage(m);
            }
        }
    }
}

