/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.facets;

import java.io.File;
import java.util.Collections;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.jboss.forge.addon.environment.Environment;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenFacetImpl;
import org.jboss.forge.addon.maven.projects.MavenProjectBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.building.BuildMessage;
import org.jboss.forge.addon.projects.building.BuildResult;
import org.jboss.forge.addon.projects.building.BuildResultBuilder;
import org.jboss.forge.addon.projects.building.ProjectBuilder;
import org.jboss.forge.addon.projects.events.PackagingChanged;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.util.Strings;

@Dependent
@FacetConstraint(value={MavenFacet.class})
public class MavenPackagingFacet
extends AbstractFacet<Project>
implements PackagingFacet {
    @Inject
    private Event<PackagingChanged> event;
    @Inject
    private ResourceFactory factory;
    @Inject
    private Environment environment;

    public void setPackagingType(String type) {
        String oldType = this.getPackagingType();
        if (!oldType.equals(type)) {
            MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = mavenFacet.getModel();
            pom.setPackaging(type);
            mavenFacet.setModel(pom);
            this.event.fire((Object)new PackagingChanged((Project)this.getFaceted(), oldType, type));
        }
    }

    public String getPackagingType() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = mavenFacet.getModel();
        String packaging = pom.getPackaging();
        if (packaging != null) {
            packaging = packaging.trim();
        }
        return packaging;
    }

    public boolean isInstalled() {
        return true;
    }

    public boolean install() {
        if (this.getPackagingType() == null || this.getPackagingType().isEmpty()) {
            this.setPackagingType("pom");
        }
        return true;
    }

    public Resource<?> getFinalArtifact() {
        MavenFacetImpl mvn = (MavenFacetImpl)((Project)this.getFaceted()).getFacet(MavenFacetImpl.class);
        try {
            Build build = mvn.getProjectBuildingResult().getProject().getBuild();
            String directory = build.getDirectory();
            String finalName = build.getFinalName();
            if (Strings.isNullOrEmpty((String)directory)) {
                throw new IllegalStateException("Project build directory is not configured");
            }
            if (Strings.isNullOrEmpty((String)finalName)) {
                throw new IllegalStateException("Project final artifact name is not configured");
            }
            return this.factory.create((Object)new File(directory.trim(), finalName + "." + this.getPackagingType().toLowerCase()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not resolve build directory for project [" + mvn.getModelResource().getFullyQualifiedName() + "]");
        }
    }

    public Resource<?> executeBuild(String ... args) {
        return this.createBuilder().addArguments(args).build();
    }

    public ProjectBuilder createBuilder() {
        return new MavenProjectBuilder(this.environment, (Project)this.getFaceted());
    }

    public String getFinalName() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = mavenFacet.getModel();
        Build build = pom.getBuild();
        return build != null ? build.getFinalName() : this.getDefaultFinalName();
    }

    private String getDefaultFinalName() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = mavenFacet.getModel();
        String version = pom.getVersion();
        if (version == null && pom.getParent() != null) {
            version = pom.getParent().getVersion();
        }
        return pom.getArtifactId() + "-" + version;
    }

    public void setFinalName(String finalName) {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = mavenFacet.getModel();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        pom.getBuild().setFinalName(finalName);
        mavenFacet.setModel(pom);
    }

    public BuildResult getBuildResult() {
        BuildResultBuilder resultBuilder = BuildResultBuilder.create();
        MavenFacetImpl mvn = (MavenFacetImpl)((Project)this.getFaceted()).getFacet(MavenFacetImpl.class);
        resultBuilder.status(mvn.isModelValid());
        try {
            ProjectBuildingResult result = mvn.getProjectBuildingResult();
            if (!result.getProblems().isEmpty()) {
                String errorMessage = new ProjectBuildingException(Collections.singletonList(result)).getMessage();
                resultBuilder.addMessage(BuildMessage.Severity.ERROR, errorMessage);
            }
        }
        catch (ProjectBuildingException e) {
            resultBuilder.addMessage(BuildMessage.Severity.ERROR, e.getMessage());
        }
        return resultBuilder.build();
    }
}

