/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.MethodHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.windup.graph.AdjacentMap;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.exception.WindupException;

public class AdjacentMapHandler
implements MethodHandler<AdjacentMap> {
    public Class<AdjacentMap> getAnnotationType() {
        return AdjacentMap.class;
    }

    public Object processElement(Object frame, Method method, Object[] arguments, AdjacentMap annotation, FramedGraph<?> framedGraph, Element element) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return this.handleGetter(element, method, arguments, annotation, framedGraph);
        }
        if (methodName.startsWith("set")) {
            this.handleSetter(element, method, arguments, annotation, framedGraph);
            return null;
        }
        throw new WindupException("Unsupported method type... only get* and set* method names are supported!");
    }

    private Map<String, WindupVertexFrame> handleGetter(Element element, Method method, Object[] arguments, AdjacentMap annotation, FramedGraph<?> framedGraph) {
        if (!(element instanceof Vertex)) {
            throw new WindupException("Error, @AdjacentMap is only supported on Vertex objects");
        }
        if (arguments != null && arguments.length != 0) {
            throw new WindupException("Error, method must take zero arguments");
        }
        HashMap<String, WindupVertexFrame> result = new HashMap<String, WindupVertexFrame>();
        Vertex vertex = (Vertex)element;
        Iterable edges = vertex.getEdges(Direction.IN, new String[]{annotation.label()});
        for (Edge edge : edges) {
            String key = (String)edge.getProperty(annotation.mapKeyField());
            Vertex v = edge.getVertex(Direction.OUT);
            WindupVertexFrame frame = (WindupVertexFrame)framedGraph.frame(v, WindupVertexFrame.class);
            result.put(key, frame);
        }
        return result;
    }

    private void handleSetter(Element element, Method method, Object[] arguments, AdjacentMap annotation, FramedGraph<?> framedGraph) {
        if (!(element instanceof Vertex)) {
            throw new WindupException("Error, @AdjacentMap is only supported on Vertex objects");
        }
        if (arguments == null || arguments.length != 1) {
            throw new WindupException("Error, method must take only one argument");
        }
        Vertex vertex = (Vertex)element;
        Iterable edges = vertex.getEdges(Direction.OUT, new String[]{annotation.label()});
        for (Edge edge : edges) {
            framedGraph.removeEdge(edge);
        }
        Map map = (Map)arguments[0];
        for (Map.Entry entry : map.entrySet()) {
            Edge edge = framedGraph.addEdge(null, ((WindupVertexFrame)entry.getValue()).asVertex(), vertex, annotation.label());
            edge.setProperty(annotation.mapKeyField(), entry.getKey());
        }
    }
}

