/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.BatchGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphConfiguration;
import com.tinkerpop.frames.FramedGraphFactory;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.FrameClassLoaderResolver;
import com.tinkerpop.frames.modules.MethodHandler;
import com.tinkerpop.frames.modules.Module;
import com.tinkerpop.frames.modules.gremlingroovy.GremlinGroovyModule;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerModule;
import java.io.File;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.graph.AdjacentMapHandler;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphTypeRegistry;
import org.jboss.windup.graph.WindupPropertyMethodHandler;
import org.jboss.windup.graph.frames.TypeAwareFramedGraphQuery;
import org.jboss.windup.graph.service.Service;

public class GraphContextImpl
implements GraphContext {
    private static final Logger log = Logger.getLogger(GraphContextImpl.class.getName());
    private final GraphTypeRegistry graphTypeRegistry;
    private final EventGraph<TitanGraph> eventGraph;
    private final BatchGraph<TitanGraph> batchGraph;
    private final FramedGraph<EventGraph<TitanGraph>> framed;
    private final Path graphDir;

    public GraphContextImpl(Imported<Service<? extends VertexFrame>> graphServices, GraphTypeRegistry graphTypeRegistry, GraphApiCompositeClassLoaderProvider classLoaderProvider, Path graphDir) {
        PropertyKey propKey;
        this.graphTypeRegistry = graphTypeRegistry;
        this.graphDir = graphDir;
        log.fine("Initializing graph.");
        FileUtils.deleteQuietly((File)graphDir.toFile());
        Path lucene = graphDir.resolve("graphsearch");
        Path berkeley = graphDir.resolve("titangraph");
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("storage.directory", (Object)berkeley.toAbsolutePath().toString());
        conf.setProperty("storage.backend", (Object)"berkeleyje");
        conf.setProperty("index.search.backend", (Object)"lucene");
        conf.setProperty("index.search.directory", (Object)lucene.toAbsolutePath().toString());
        TitanGraph titanGraph = TitanFactory.open((Configuration)conf);
        String[] keys = new String[]{"namespaceURI", "schemaLocation", "publicId", "rootTagName", "systemId", "qualifiedName", "filePath", "mavenIdentifier", "packageName", "classification"};
        TitanManagement mgmt = titanGraph.getManagementSystem();
        for (String key : keys) {
            propKey = mgmt.makePropertyKey(key).dataType(String.class).cardinality(Cardinality.SINGLE).make();
            mgmt.buildIndex(key, Vertex.class).addKey(propKey).buildCompositeIndex();
        }
        for (String key : new String[]{"archiveEntry"}) {
            propKey = mgmt.makePropertyKey(key).dataType(String.class).cardinality(Cardinality.SINGLE).make();
            mgmt.buildIndex(key, Vertex.class).addKey(propKey).buildMixedIndex("search");
        }
        for (String key : new String[]{"w:vertextype"}) {
            propKey = mgmt.makePropertyKey(key).dataType(String.class).cardinality(Cardinality.LIST).make();
            mgmt.buildIndex(key, Vertex.class).addKey(propKey).buildCompositeIndex();
        }
        mgmt.commit();
        this.eventGraph = new EventGraph((Graph)titanGraph);
        this.batchGraph = new BatchGraph((TransactionalGraph)titanGraph, 1000L);
        final ClassLoader compositeClassLoader = classLoaderProvider.getCompositeClassLoader();
        final AdjacentMapHandler frameMapHandler = new AdjacentMapHandler();
        final FrameClassLoaderResolver fclr = new FrameClassLoaderResolver(){

            public ClassLoader resolveClassLoader(Class<?> frameType) {
                return compositeClassLoader;
            }
        };
        Module addModules = new Module(){

            public Graph configure(Graph baseGraph, FramedGraphConfiguration config) {
                config.setFrameClassLoaderResolver(fclr);
                config.addMethodHandler((MethodHandler)frameMapHandler);
                config.addMethodHandler((MethodHandler)new WindupPropertyMethodHandler());
                return baseGraph;
            }
        };
        FramedGraphFactory factory = new FramedGraphFactory(new Module[]{addModules, new JavaHandlerModule(), graphTypeRegistry.build(), new GremlinGroovyModule()});
        this.framed = factory.create(this.eventGraph);
    }

    public GraphTypeRegistry getGraphTypeRegistry() {
        return this.graphTypeRegistry;
    }

    public void close() {
        ((TitanGraph)this.eventGraph.getBaseGraph()).shutdown();
    }

    public void clear() {
        TitanCleanup.clear((TitanGraph)((TitanGraph)this.eventGraph.getBaseGraph()));
    }

    public EventGraph<TitanGraph> getGraph() {
        return this.eventGraph;
    }

    public BatchGraph<TitanGraph> getBatch() {
        return this.batchGraph;
    }

    public FramedGraph<EventGraph<TitanGraph>> getFramed() {
        return this.framed;
    }

    public TypeAwareFramedGraphQuery getQuery() {
        return new TypeAwareFramedGraphQuery(this.getFramed());
    }

    public Path getGraphDirectory() {
        return this.graphDir;
    }

    public String toString() {
        String graphHash = this.getGraph() == null ? "null" : "" + this.getGraph().hashCode();
        return "GraphContextImpl(" + this.hashCode() + "), Graph(" + graphHash + ") + DataDir(" + this.getGraphDirectory() + ")";
    }
}

