/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.xadisk.bridge.proxies.facilitators.RemoteMethodInvoker;
import org.xadisk.bridge.proxies.impl.RemoteConcurrencyControl;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpointFactory;
import org.xadisk.bridge.proxies.impl.RemoteXAFileSystem;
import org.xadisk.bridge.proxies.interfaces.XAFileSystem;
import org.xadisk.bridge.proxies.interfaces.XASession;
import org.xadisk.bridge.server.PointOfContact;
import org.xadisk.bridge.server.conversation.GlobalHostedContext;
import org.xadisk.connector.XAResourceImpl;
import org.xadisk.connector.inbound.DeadLetterMessageEndpoint;
import org.xadisk.connector.inbound.EndPointActivation;
import org.xadisk.connector.inbound.LocalEventProcessingXAResource;
import org.xadisk.filesystem.ConcurrencyControl;
import org.xadisk.filesystem.DurableDiskSession;
import org.xadisk.filesystem.FileSystemConfiguration;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeConcurrencyControl;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.NativeXASession;
import org.xadisk.filesystem.TransactionInformation;
import org.xadisk.filesystem.XAFileSystemCommonness;
import org.xadisk.filesystem.exceptions.RecoveryInProgressException;
import org.xadisk.filesystem.exceptions.XASystemBootFailureException;
import org.xadisk.filesystem.exceptions.XASystemException;
import org.xadisk.filesystem.exceptions.XASystemNoMoreAvailableException;
import org.xadisk.filesystem.pools.BufferPool;
import org.xadisk.filesystem.pools.SelectorPool;
import org.xadisk.filesystem.standalone.StandaloneFileSystemConfiguration;
import org.xadisk.filesystem.standalone.StandaloneWorkManager;
import org.xadisk.filesystem.utilities.FileIOUtility;
import org.xadisk.filesystem.utilities.Logger;
import org.xadisk.filesystem.workers.CrashRecoveryWorker;
import org.xadisk.filesystem.workers.FileSystemEventDelegator;
import org.xadisk.filesystem.workers.GatheringDiskWriter;
import org.xadisk.filesystem.workers.ObjectPoolReliever;
import org.xadisk.filesystem.workers.TransactionTimeoutDetector;
import org.xadisk.filesystem.workers.observers.CriticalWorkersListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeXAFileSystem
implements XAFileSystemCommonness {
    private static ConcurrentHashMap<String, NativeXAFileSystem> allXAFileSystems = new ConcurrentHashMap();
    private final AtomicLong lastTransactionId = new AtomicLong(System.currentTimeMillis() / 1000L);
    private final BufferPool bufferPool;
    private final SelectorPool selectorPool;
    private final String transactionLogFileBaseName;
    private Logger logger;
    private final String transactionLogsDir;
    private final DeadLetterMessageEndpoint deadLetter;
    private final FileSystemConfiguration configuration;
    private final ConcurrentHashMap<TransactionInformation, NativeSession> transactionAndSession = new ConcurrentHashMap(1000);
    private HashSet<TransactionInformation> transactionsPreparedPreCrash;
    private boolean returnedAllPreparedTransactions = false;
    private final WorkManager workManager;
    private final GatheringDiskWriter gatheringDiskWriter;
    private final CrashRecoveryWorker recoveryWorker;
    private final ObjectPoolReliever bufferPoolReliever;
    private final ObjectPoolReliever selectorPoolReliever;
    private final FileSystemEventDelegator fileSystemEventDelegator;
    private final TransactionTimeoutDetector transactionTimeoutDetector;
    private final PointOfContact pointOfContact;
    private boolean recoveryComplete = false;
    private final LinkedBlockingQueue<FileSystemStateChangeEvent> fileSystemEventQueue;
    private volatile boolean systemHasFailed = false;
    private volatile Throwable systemFailureCause = null;
    private volatile boolean systemShuttingDown = false;
    private final CriticalWorkersListener workListener;
    private final File topLevelBackupDir;
    private File currentBackupDirPath;
    private AtomicLong backupFileNameCounter = new AtomicLong(0L);
    private final int maxFilesInBackupDirectory = 100000;
    private final GlobalHostedContext globalCallbackContext = new GlobalHostedContext();
    private final AtomicLong totalNonPooledBufferSize = new AtomicLong(0L);
    private final ConcurrencyControl concurrencyControl;
    private final boolean handleGeneralRemoteInvocations;
    private final boolean handleClusterRemoteInvocations;
    private final ConcurrentLinkedQueue<TransactionInformation> failedTransactions = new ConcurrentLinkedQueue();
    public static final int FILE_CHANNEL_MAX_TRANSFER = 0x800000;

    private NativeXAFileSystem(FileSystemConfiguration configuration, WorkManager workManager) {
        this.configuration = configuration;
        this.workManager = workManager;
        try {
            boolean success;
            File xaDiskHome = new File(configuration.getXaDiskHome()).getAbsoluteFile();
            String xaDiskHomePath = xaDiskHome.getPath();
            FileIOUtility.createDirectoriesIfRequired(xaDiskHome);
            this.topLevelBackupDir = new File(xaDiskHome, "backupDir");
            this.logger = new Logger(new File(xaDiskHome, "xadisk.log"), 3);
            if (configuration.getSynchronizeDirectoryChanges().booleanValue() && !(success = DurableDiskSession.setupDirectorySynchronization(xaDiskHome))) {
                this.logger.logWarning("XADisk has failed to load its native library required for directory-synchronization.\nNow, it will override the configuration property \"synchronizeDirectoryChanges\" and set it to false; but please note that this would turn-off directory-synchronization i.e. directory modifications may not get synchronized to the disk at transaction commit.\nIf you have any questions or think this exception is not expected, please consider discussing in XADisk forums, or raising a bug with details.");
                configuration.setSynchronizeDirectoryChanges(false);
            }
            DurableDiskSession diskSession = this.createDurableDiskSession();
            if (!this.topLevelBackupDir.isDirectory()) {
                diskSession.createDirectory(this.topLevelBackupDir);
            }
            this.transactionLogsDir = xaDiskHomePath + File.separator + "txnlogs";
            diskSession.createDirectoriesIfRequired(new File(this.transactionLogsDir));
            this.transactionLogFileBaseName = this.transactionLogsDir + File.separator + "xadisk.log";
            this.bufferPool = new BufferPool(configuration.getDirectBufferPoolSize(), configuration.getNonDirectBufferPoolSize(), configuration.getBufferSize(), configuration.getDirectBufferIdleTime(), configuration.getNonDirectBufferIdleTime(), this);
            this.selectorPool = new SelectorPool(1000);
            this.gatheringDiskWriter = new GatheringDiskWriter(configuration.getCumulativeBufferSizeForDiskWrite(), configuration.getTransactionLogFileMaxSize(), configuration.getMaxNonPooledBufferSize(), this.transactionLogFileBaseName, this);
            this.recoveryWorker = new CrashRecoveryWorker(this);
            this.bufferPoolReliever = new ObjectPoolReliever(this.bufferPool, configuration.getBufferPoolRelieverInterval(), this);
            this.selectorPoolReliever = new ObjectPoolReliever(this.selectorPool, 1000, this);
            this.transactionTimeoutDetector = new TransactionTimeoutDetector(1, this);
            this.fileSystemEventQueue = new LinkedBlockingQueue();
            this.fileSystemEventDelegator = new FileSystemEventDelegator(this, configuration.getMaximumConcurrentEventDeliveries());
            this.workListener = new CriticalWorkersListener(this);
            File deadLetterDir = new File(xaDiskHome, "deadletter");
            diskSession.createDirectoriesIfRequired(deadLetterDir);
            this.deadLetter = new DeadLetterMessageEndpoint(deadLetterDir, this);
            diskSession.forceToDisk();
            if (configuration.getEnableClusterMode().booleanValue()) {
                if (NativeXAFileSystem.isValidString(configuration.getClusterMasterAddress())) {
                    this.handleClusterRemoteInvocations = false;
                    String clusterMasterAddress = configuration.getClusterMasterAddress();
                    if (clusterMasterAddress.charAt(0) == '#') {
                        String clusterMasterInstanceId = clusterMasterAddress.substring(1);
                        this.concurrencyControl = NativeXAFileSystem.getXAFileSystem(clusterMasterInstanceId).getConcurrencyControl();
                    } else {
                        Integer clusterMasterPort = configuration.getClusterMasterPort();
                        this.concurrencyControl = new RemoteConcurrencyControl(clusterMasterAddress, clusterMasterPort);
                    }
                } else {
                    this.handleClusterRemoteInvocations = true;
                    this.concurrencyControl = new NativeConcurrencyControl(configuration, workManager, this.workListener, this);
                }
            } else {
                this.handleClusterRemoteInvocations = false;
                this.concurrencyControl = new NativeConcurrencyControl(configuration, workManager, this.workListener, this);
            }
            workManager.startWork((Work)this.bufferPoolReliever, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.selectorPoolReliever, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.fileSystemEventDelegator, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.transactionTimeoutDetector, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            this.handleGeneralRemoteInvocations = configuration.getEnableRemoteInvocations();
            if (this.handleClusterRemoteInvocations || this.handleGeneralRemoteInvocations) {
                this.pointOfContact = new PointOfContact(this, configuration.getServerPort());
                workManager.startWork((Work)this.pointOfContact, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            } else {
                this.pointOfContact = null;
            }
            this.recoveryWorker.collectRecoveryData();
            this.gatheringDiskWriter.initialize();
            workManager.startWork((Work)this.gatheringDiskWriter, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.recoveryWorker, Long.MAX_VALUE, null, (WorkListener)this.workListener);
        }
        catch (Exception e) {
            XASystemBootFailureException xasbfe = new XASystemBootFailureException(e);
            if (this.logger != null) {
                this.logger.logThrowable(xasbfe, (byte)1);
            }
            throw xasbfe;
        }
    }

    public static NativeXAFileSystem bootXAFileSystem(FileSystemConfiguration configuration, WorkManager workManager) {
        NativeXAFileSystem.doBasicValidationForConfiguration(configuration);
        String instanceId = configuration.getInstanceId();
        if (allXAFileSystems.get(instanceId) != null) {
            throw new XASystemBootFailureException("An instance of XADisk with instance-id [" + instanceId + "] is already" + " running in this JVM.");
        }
        NativeXAFileSystem newXAFileSystem = new NativeXAFileSystem(configuration, workManager);
        allXAFileSystems.put(configuration.getInstanceId(), newXAFileSystem);
        newXAFileSystem.logger.logInfo("Successfully booted the XADisk instance.");
        return newXAFileSystem;
    }

    public static NativeXAFileSystem bootXAFileSystemStandAlone(StandaloneFileSystemConfiguration configuration) {
        NativeXAFileSystem.doBasicValidationForConfiguration(configuration);
        String instanceId = configuration.getInstanceId();
        if (allXAFileSystems.get(instanceId) != null) {
            throw new XASystemBootFailureException("An instance of XADisk with instance-id [" + instanceId + "] is already" + " running in this JVM.");
        }
        StandaloneWorkManager workManager = new StandaloneWorkManager(configuration.getWorkManagerCorePoolSize(), configuration.getWorkManagerMaxPoolSize(), configuration.getWorkManagerKeepAliveTime());
        NativeXAFileSystem newXAFileSystem = new NativeXAFileSystem(configuration, workManager);
        allXAFileSystems.put(configuration.getInstanceId(), newXAFileSystem);
        newXAFileSystem.logger.logInfo("Successfully booted the XADisk instance.");
        return newXAFileSystem;
    }

    public static NativeXAFileSystem getXAFileSystem(String instanceId) {
        return allXAFileSystems.get(instanceId);
    }

    @Override
    public boolean pointToSameXAFileSystem(XAFileSystem xaFileSystem) {
        if (xaFileSystem instanceof NativeXAFileSystem && !(xaFileSystem instanceof RemoteXAFileSystem)) {
            NativeXAFileSystem that = (NativeXAFileSystem)xaFileSystem;
            return this.configuration.getInstanceId().equals(that.configuration.getInstanceId());
        }
        return false;
    }

    private static void doBasicValidationForConfiguration(FileSystemConfiguration configuration) {
        if (!NativeXAFileSystem.isValidString(configuration.getXaDiskHome())) {
            throw new XASystemBootFailureException("Invalid value of configuration property [xaDiskHome]");
        }
        if (!NativeXAFileSystem.isValidString(configuration.getInstanceId())) {
            throw new XASystemBootFailureException("Invalid value of configuration property [instanceId]");
        }
    }

    private static boolean isValidString(String s) {
        return s != null && s.trim().length() > 0;
    }

    public void notifyRecoveryComplete() throws IOException {
        this.fileSystemEventQueue.addAll(this.recoveryWorker.getEventsEnqueueCommittedNotDequeued());
        DurableDiskSession diskSession = this.createDurableDiskSession();
        diskSession.deleteDirectoryRecursively(this.topLevelBackupDir);
        diskSession.createDirectory(this.topLevelBackupDir);
        this.backupFileNameCounter.set(0L);
        this.currentBackupDirPath = new File(this.topLevelBackupDir.getAbsolutePath(), "deeper");
        diskSession.createDirectory(this.currentBackupDirPath);
        diskSession.forceToDisk();
        this.recoveryComplete = true;
    }

    @Override
    public NativeSession createSessionForLocalTransaction() {
        this.checkIfCanContinue();
        NativeSession session = new NativeSession(TransactionInformation.getXidInstanceForLocalTransaction(this.getNextLocalTransactionId()), false, this);
        return session;
    }

    @Override
    public NativeSession createSessionForXATransaction(Xid xid) {
        this.checkIfCanContinue();
        NativeSession session = new NativeSession((TransactionInformation)xid, false, this);
        return session;
    }

    @Override
    public XASession createSessionForXATransaction() {
        this.checkIfCanContinue();
        return new NativeXASession(this, this.configuration.getInstanceId());
    }

    @Override
    public XAResource getXAResourceForRecovery() {
        return new XAResourceImpl(new NativeXASession(this, this.configuration.getInstanceId()));
    }

    @Override
    public NativeSession getSessionForTransaction(Xid xid) {
        ArrayList<FileSystemStateChangeEvent> events;
        NativeSession session = this.transactionAndSession.get((TransactionInformation)xid);
        if (session != null) {
            return session;
        }
        if (this.transactionsPreparedPreCrash != null && this.transactionsPreparedPreCrash.contains((TransactionInformation)xid) && (session = (events = this.recoveryWorker.getEventsFromPreparedTransaction((TransactionInformation)xid)) != null ? new NativeSession((TransactionInformation)xid, events, this) : new NativeSession((TransactionInformation)xid, true, this)) != null) {
            return session;
        }
        return null;
    }

    void removeTransactionSessionEntry(TransactionInformation xid) {
        this.transactionAndSession.remove(xid);
    }

    void assignSessionToTransaction(TransactionInformation xid, NativeSession session) {
        this.transactionAndSession.put(xid, session);
    }

    public NativeSession[] getAllSessions() {
        Collection<NativeSession> sessions = this.transactionAndSession.values();
        return sessions.toArray(new NativeSession[0]);
    }

    public NativeSession createRecoverySession(TransactionInformation xid, ArrayList<FileSystemStateChangeEvent> events) {
        if (events == null) {
            return new NativeSession(xid, true, this);
        }
        return new NativeSession(xid, events, this);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (flag == 0x1000000) {
            this.returnedAllPreparedTransactions = false;
        }
        if (flag == 0x1800000) {
            this.returnedAllPreparedTransactions = false;
        }
        if (this.returnedAllPreparedTransactions) {
            return new Xid[0];
        }
        this.transactionsPreparedPreCrash = this.recoveryWorker.getPreparedInDoubtTransactions();
        Xid[] xids = this.transactionsPreparedPreCrash.toArray(new Xid[0]);
        this.returnedAllPreparedTransactions = true;
        return xids;
    }

    public void notifyTransactionFailure(TransactionInformation xid) {
        this.failedTransactions.add(xid);
    }

    @Override
    public byte[][] getIdentifiersForFailedTransactions() {
        TransactionInformation[] identifiers = this.failedTransactions.toArray(new TransactionInformation[0]);
        byte[][] identifiersBytes = new byte[identifiers.length][];
        int i = 0;
        for (TransactionInformation identifier : identifiers) {
            identifiersBytes[i++] = identifier.getBytes();
        }
        return identifiersBytes;
    }

    @Override
    public void declareTransactionAsComplete(byte[] transactionIdentifier) {
        try {
            TransactionInformation xid = new TransactionInformation(ByteBuffer.wrap(transactionIdentifier));
            this.gatheringDiskWriter.transactionCompletes(xid, true);
            NativeSession session = this.transactionAndSession.get(xid);
            if (session != null) {
                session.completeTheTransaction();
            } else {
                this.recoveryWorker.cleanupTransactionInfo(xid);
            }
            this.failedTransactions.remove(xid);
        }
        catch (IOException ioe) {
            this.notifySystemFailure(ioe);
        }
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public SelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    public GlobalHostedContext getGlobalCallbackContext() {
        return this.globalCallbackContext;
    }

    public GatheringDiskWriter getTheGatheringDiskWriter() {
        return this.gatheringDiskWriter;
    }

    public String getTransactionLogFileBaseName() {
        return this.transactionLogFileBaseName;
    }

    public String getTransactionLogsDir() {
        return this.transactionLogsDir;
    }

    public CrashRecoveryWorker getRecoveryWorker() {
        return this.recoveryWorker;
    }

    public int getConfiguredBufferSize() {
        return this.configuration.getBufferSize();
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public ArrayList<EndPointActivation> getAllActivations() {
        return this.fileSystemEventDelegator.getAllActivations();
    }

    public void startWork(Work work) throws WorkException {
        this.workManager.startWork(work, Long.MAX_VALUE, null, (WorkListener)this.workListener);
    }

    public ConcurrencyControl getConcurrencyControl() {
        if (this.concurrencyControl instanceof RemoteConcurrencyControl) {
            return ((RemoteConcurrencyControl)this.concurrencyControl).getNewInstance();
        }
        return this.concurrencyControl;
    }

    public long getNextLocalTransactionId() {
        return this.lastTransactionId.getAndIncrement();
    }

    Logger getLogger() {
        return this.logger;
    }

    @Override
    public void shutdown() throws IOException {
        this.logger.logInfo("Shutting down the XADisk instance...");
        this.systemShuttingDown = true;
        Collection<NativeSession> sessionsCollection = this.transactionAndSession.values();
        NativeSession[] allSessions = sessionsCollection.toArray(new NativeSession[0]);
        for (int i = 0; i < allSessions.length; ++i) {
            allSessions[i].notifySystemShutdown();
        }
        this.bufferPoolReliever.release();
        this.selectorPoolReliever.release();
        this.concurrencyControl.shutdown();
        this.recoveryWorker.release();
        this.gatheringDiskWriter.release();
        this.gatheringDiskWriter.deInitialize();
        this.fileSystemEventDelegator.release();
        this.transactionTimeoutDetector.release();
        if (this.configuration.getEnableRemoteInvocations().booleanValue()) {
            this.pointOfContact.release();
        }
        this.deadLetter.release();
        if (this.workManager instanceof StandaloneWorkManager) {
            ((StandaloneWorkManager)this.workManager).shutdown();
        }
        allXAFileSystems.remove(this.configuration.getInstanceId());
        this.logger.logInfo("Successfully shutdown the XADisk instance.");
        this.logger.release();
    }

    int getLockTimeOut() {
        return this.configuration.getLockTimeOut();
    }

    public File getNextBackupFileName() throws IOException {
        File savedCurrentBackupDir = this.currentBackupDirPath;
        long nextBackupFileName = this.backupFileNameCounter.getAndIncrement();
        if (nextBackupFileName >= 100000L) {
            if (nextBackupFileName == 100000L) {
                this.currentBackupDirPath = new File(this.currentBackupDirPath, "deeper");
                this.createDurableDiskSession().createDirectoryDurably(this.currentBackupDirPath);
                this.backupFileNameCounter.set(0L);
            } else {
                while (this.backupFileNameCounter.get() >= 100000L) {
                }
            }
        }
        return new File(savedCurrentBackupDir, nextBackupFileName + "");
    }

    public LinkedBlockingQueue<FileSystemStateChangeEvent> getFileSystemEventQueue() {
        return this.fileSystemEventQueue;
    }

    public final DurableDiskSession createDurableDiskSession() {
        return new DurableDiskSession(this.configuration.getSynchronizeDirectoryChanges());
    }

    @Override
    public void registerEndPointActivation(EndPointActivation activation) throws IOException {
        boolean notADuplicateActivation = this.fileSystemEventDelegator.registerActivation(activation);
        if (notADuplicateActivation && activation.getMessageEndpointFactory() instanceof RemoteMessageEndpointFactory) {
            this.gatheringDiskWriter.recordEndPointActivation(activation);
            ((RemoteMessageEndpointFactory)activation.getMessageEndpointFactory()).setLocalXAFileSystem(this);
        }
    }

    @Override
    public void deRegisterEndPointActivation(EndPointActivation activation) throws IOException {
        this.fileSystemEventDelegator.deRegisterActivation(activation);
        if (activation.getMessageEndpointFactory() instanceof RemoteMessageEndpointFactory) {
            this.gatheringDiskWriter.recordEndPointDeActivation(activation);
        }
    }

    FileSystemEventDelegator getFileSystemEventDelegator() {
        return this.fileSystemEventDelegator;
    }

    public void notifySystemFailure(Throwable systemFailureCause) {
        this.systemHasFailed = true;
        this.systemFailureCause = systemFailureCause;
        Collection<NativeSession> sessionsCollection = this.transactionAndSession.values();
        NativeSession[] allSessions = sessionsCollection.toArray(new NativeSession[0]);
        for (int i = 0; i < allSessions.length; ++i) {
            allSessions[i].notifySystemFailure(systemFailureCause);
        }
        throw new XASystemNoMoreAvailableException(systemFailureCause);
    }

    @Override
    public void notifySystemFailureAndContinue(Throwable systemFailureCause) {
        try {
            this.notifySystemFailure(systemFailureCause);
        }
        catch (XASystemException xASystemException) {
            // empty catch block
        }
    }

    private void checkIfCanContinue() {
        if (this.systemHasFailed) {
            throw new XASystemNoMoreAvailableException(this.systemFailureCause);
        }
        if (!this.recoveryComplete) {
            throw new RecoveryInProgressException();
        }
        if (this.systemShuttingDown) {
            throw new XASystemNoMoreAvailableException();
        }
    }

    @Override
    public void waitForBootup(long timeout) throws InterruptedException {
        block7: {
            if (timeout < 0L) {
                while (true) {
                    try {
                        this.checkIfCanContinue();
                        break block7;
                    }
                    catch (RecoveryInProgressException ripe) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    break;
                }
            }
            for (long timer = timeout; timer > 0L; timer -= 1000L) {
                try {
                    this.checkIfCanContinue();
                    break;
                }
                catch (RecoveryInProgressException ripe) {
                    Thread.sleep(1000L);
                    continue;
                }
            }
            this.checkIfCanContinue();
        }
    }

    @Override
    public int getDefaultTransactionTimeout() {
        return this.configuration.getTransactionTimeout();
    }

    public String getXADiskSystemId() {
        return this.configuration.getServerAddress() + "_" + this.configuration.getServerPort();
    }

    public RemoteMethodInvoker createRemoteMethodInvokerToSelf() {
        return new RemoteMethodInvoker(this.configuration.getServerAddress(), this.configuration.getServerPort());
    }

    @Override
    public XAResource getEventProcessingXAResourceForRecovery() {
        return new LocalEventProcessingXAResource(this);
    }

    public DeadLetterMessageEndpoint getDeadLetter() {
        return this.deadLetter;
    }

    public void changeTotalNonPooledBufferSize(int changeAmount) {
        this.totalNonPooledBufferSize.addAndGet(changeAmount);
    }

    public long getTotalNonPooledBufferSize() {
        return this.totalNonPooledBufferSize.get();
    }

    public static long maxTransferToChannel(long upperLimitOnBytes) {
        return Math.min(upperLimitOnBytes, 0x800000L);
    }

    public boolean getHandleClusterRemoteInvocations() {
        return this.handleClusterRemoteInvocations;
    }

    public boolean getHandleGeneralRemoteInvocations() {
        return this.handleGeneralRemoteInvocations;
    }
}

