/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.command;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.CommandProvider;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Commands;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.services.Imported;

@Singleton
public class CommandFactoryImpl
implements CommandFactory {
    @Inject
    private AddonRegistry registry;
    private static final Logger log = Logger.getLogger(CommandFactoryImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<UICommand> getCommands() {
        HashSet<UICommand> result = new HashSet<UICommand>();
        CommandFactoryImpl commandFactoryImpl = this;
        synchronized (commandFactoryImpl) {
            Imported instances = this.registry.getServices(CommandProvider.class);
            for (CommandProvider provider : instances) {
                Iterable commands = provider.getCommands();
                Iterator iterator = commands.iterator();
                while (iterator.hasNext()) {
                    try {
                        UICommand command = (UICommand)iterator.next();
                        if (command instanceof UIWizardStep) continue;
                        result.add(command);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error while retrieving command instance", e);
                    }
                }
                instances.release((Object)provider);
            }
        }
        return result;
    }

    public Set<String> getEnabledCommandNames(UIContext context) {
        TreeSet<String> commands = new TreeSet<String>();
        Iterable<UICommand> allCommands = this.getCommands();
        for (UICommand cmd : allCommands) {
            try {
                if (!Commands.isEnabled((UICommand)cmd, (UIContext)context)) continue;
                commands.add(this.getCommandName(context, cmd));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while checking if command " + cmd + " isEnabled", e);
            }
        }
        return commands;
    }

    public String getCommandName(UIContext context, UICommand cmd) {
        String name = null;
        try {
            UICommandMetadata metadata = cmd.getMetadata(context);
            name = metadata.getName();
            if (!context.getProvider().isGUI()) {
                name = CommandFactoryImpl.shellifyName(name);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error while getting command name for " + cmd.getClass(), e);
        }
        return name;
    }

    public Set<String> getCommandNames(UIContext context) {
        TreeSet<String> commands = new TreeSet<String>();
        for (UICommand cmd : this.getCommands()) {
            String commandName = this.getCommandName(context, cmd);
            if (commandName == null) continue;
            commands.add(commandName);
        }
        return commands;
    }

    public UICommand getCommandByName(UIContext context, String name) {
        for (UICommand cmd : this.getCommands()) {
            String commandName = this.getCommandName(context, cmd);
            if (!name.equals(commandName)) continue;
            return cmd;
        }
        return null;
    }

    private static String shellifyName(String name) {
        return name.trim().toLowerCase().replaceAll("\\W+", "-").replaceAll("\\:", "");
    }
}

