/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.context;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.impl.output.UIMessageImpl;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.output.UIMessage;
import org.jboss.forge.furnace.util.Assert;

public class UIValidationContextImpl
implements UIValidationContext {
    private List<UIMessage> messages = new LinkedList<UIMessage>();
    private UIContext context;
    private InputComponent<?, ?> currentInputComponent;

    public UIValidationContextImpl(UIContext context) {
        this.context = context;
    }

    public void addValidationError(InputComponent<?, ?> input, String errorMessage) {
        Assert.notNull((Object)errorMessage, (String)"Error Message cannot be null");
        this.messages.add(new UIMessageImpl(UIMessage.Severity.ERROR, errorMessage, input));
    }

    public void addValidationWarning(InputComponent<?, ?> input, String warningMessage) {
        Assert.notNull((Object)warningMessage, (String)"Warning Message cannot be null");
        this.messages.add(new UIMessageImpl(UIMessage.Severity.WARN, warningMessage, input));
    }

    public void addValidationInformation(InputComponent<?, ?> input, String infoMessage) {
        Assert.notNull((Object)infoMessage, (String)"Information Message cannot be null");
        this.messages.add(new UIMessageImpl(UIMessage.Severity.INFO, infoMessage, input));
    }

    public InputComponent<?, ?> getCurrentInputComponent() {
        return this.currentInputComponent;
    }

    public void setCurrentInputComponent(InputComponent<?, ?> currentInputComponent) {
        this.currentInputComponent = currentInputComponent;
    }

    public UIContext getUIContext() {
        return this.context;
    }

    public List<UIMessage> getMessages() {
        Collections.sort(this.messages, new Comparator<UIMessage>(){

            @Override
            public int compare(UIMessage o1, UIMessage o2) {
                return o1.getSeverity().compareTo((Enum)o2.getSeverity());
            }
        });
        return this.messages;
    }
}

