/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.client.query;

import java.util.Iterator;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.AbstractQuery;

public abstract class AbstractHTTPQuery
extends AbstractQuery {
    private final HTTPClient httpClient;
    protected final QueryLanguage queryLanguage;
    protected final String queryString;
    protected final String baseURI;

    public AbstractHTTPQuery(HTTPClient httpClient, QueryLanguage queryLanguage, String queryString, String baseURI) {
        this.httpClient = httpClient;
        this.queryLanguage = queryLanguage;
        this.queryString = queryString;
        this.baseURI = baseURI != null && baseURI.length() > 0 ? baseURI : null;
    }

    protected HTTPClient getHttpClient() {
        return this.httpClient;
    }

    public Binding[] getBindingsArray() {
        BindingSet bindings = this.getBindings();
        Binding[] bindingsArray = new Binding[bindings.size()];
        Iterator iter = bindings.iterator();
        for (int i = 0; i < bindings.size(); ++i) {
            bindingsArray[i] = (Binding)iter.next();
        }
        return bindingsArray;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        super.setMaxQueryTime(maxQueryTime);
        this.httpClient.setConnectionTimeout(1000L * (long)this.maxQueryTime);
    }

    public String toString() {
        return this.queryString;
    }
}

