/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.reporting.model.ApplicationReportIndexModel;
import org.jboss.windup.reporting.service.ApplicationReportIndexService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateApplicationReportIndexRuleProvider
extends WindupRuleProvider {
    public RulePhase getPhase() {
        return RulePhase.PRE_REPORT_GENERATION;
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind applicationsFound = Query.find(WindupConfigurationModel.class);
        AbstractIterationOperation<WindupConfigurationModel> addApplicationReportIndex = new AbstractIterationOperation<WindupConfigurationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel payload) {
                ProjectModel projectModel = payload.getInputPath().getProjectModel();
                if (projectModel == null) {
                    String msg = payload.isSourceMode() ? "source-based input directory" : "archive";
                    throw new WindupException("Error, no project found in " + msg + ": " + payload.getInputPath().getFilePath());
                }
                CreateApplicationReportIndexRuleProvider.this.createApplicationReportIndex(event.getGraphContext(), projectModel);
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationsFound).perform((Operation)addApplicationReportIndex);
    }

    private ApplicationReportIndexModel createApplicationReportIndex(GraphContext context, ProjectModel applicationProjectModel) {
        ApplicationReportIndexService applicationReportIndexService = new ApplicationReportIndexService(context);
        ApplicationReportIndexModel index = (ApplicationReportIndexModel)applicationReportIndexService.create();
        this.addAllProjectModels(index, applicationProjectModel);
        return index;
    }

    private void addAllProjectModels(ApplicationReportIndexModel navIdx, ProjectModel projectModel) {
        navIdx.addProjectModel(projectModel);
        for (ProjectModel childProject : projectModel.getChildProjects()) {
            this.addAllProjectModels(navIdx, childProject);
        }
    }
}

