/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution.scope.internal;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.util.Providers;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.WeakMojoExecutionListener;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Named
@Singleton
public class MojoExecutionScope
implements Scope,
MojoExecutionListener {
    private static final Provider<Object> SEEDED_KEY_PROVIDER = new Provider<Object>(){

        public Object get() {
            throw new IllegalStateException();
        }
    };
    private final ThreadLocal<LinkedList<ScopeState>> values = new ThreadLocal();

    public void enter() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null) {
            stack = new LinkedList();
            this.values.set(stack);
        }
        stack.addFirst(new ScopeState());
    }

    private ScopeState getScopeState() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        return stack.getFirst();
    }

    public void exit() throws MojoExecutionException {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        stack.removeFirst();
        if (stack.isEmpty()) {
            this.values.remove();
        }
    }

    public <T> void seed(Class<T> clazz, Provider<T> value) {
        this.getScopeState().seeded.put(Key.get(clazz), value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.getScopeState().seeded.put(Key.get(clazz), Providers.of(value));
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                LinkedList stack = (LinkedList)MojoExecutionScope.this.values.get();
                if (stack == null || stack.isEmpty()) {
                    throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
                }
                ScopeState state = (ScopeState)stack.getFirst();
                Provider<?> seeded = state.seeded.get(key);
                if (seeded != null) {
                    return seeded.get();
                }
                Object provided = state.provided.get(key);
                if (provided == null && unscoped != null) {
                    provided = unscoped.get();
                    state.provided.put(key, provided);
                }
                return provided;
            }
        };
    }

    public static <T> Provider<T> seededKeyProvider() {
        return SEEDED_KEY_PROVIDER;
    }

    public static Module getScopeModule(PlexusContainer container) throws ComponentLookupException {
        final MojoExecutionScope scope = (MojoExecutionScope)container.lookup(MojoExecutionScope.class);
        return new AbstractModule(){

            /*
             * Exception decompiling
             */
            protected void configure() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
                 *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    @Override
    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.beforeMojoExecution(event);
        }
    }

    @Override
    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.afterMojoExecutionSuccess(event);
        }
    }

    @Override
    public void afterExecutionFailure(MojoExecutionEvent event) {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.afterExecutionFailure(event);
        }
    }

    private Collection<WeakMojoExecutionListener> getProvidedListeners() {
        IdentityHashMap listeners = new IdentityHashMap();
        for (Object provided : this.getScopeState().provided.values()) {
            if (!(provided instanceof WeakMojoExecutionListener)) continue;
            listeners.put((WeakMojoExecutionListener)provided, null);
        }
        return listeners.keySet();
    }

    private static final class ScopeState {
        public final Map<Key<?>, Provider<?>> seeded = Maps.newHashMap();
        public final Map<Key<?>, Object> provided = Maps.newHashMap();

        private ScopeState() {
        }
    }
}

