/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.complete;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.TerminalString;

public class CompleteOperation {
    private String buffer;
    private int cursor;
    private int offset;
    private List<TerminalString> completionCandidates;
    private boolean trimmed = false;
    private boolean ignoreStartsWith = false;
    private String nonTrimmedBuffer;
    private final AeshContext aeshContext;
    private char separator = (char)32;
    private boolean appendSeparator = true;
    private boolean ignoreOffset = false;

    public CompleteOperation(AeshContext aeshContext, String buffer, int cursor) {
        this.aeshContext = aeshContext;
        this.setCursor(cursor);
        this.setSeparator(' ');
        this.doAppendSeparator(true);
        this.completionCandidates = new ArrayList<TerminalString>();
        this.setBuffer(buffer);
    }

    public String getBuffer() {
        return this.buffer;
    }

    private void setBuffer(String buffer) {
        if (buffer != null && buffer.startsWith(" ")) {
            this.trimmed = true;
            this.buffer = Parser.trimInFront(buffer);
            this.nonTrimmedBuffer = buffer;
            this.setCursor(this.cursor - this.getTrimmedSize());
        } else {
            this.buffer = buffer;
        }
    }

    public boolean isTrimmed() {
        return this.trimmed;
    }

    public int getTrimmedSize() {
        return this.nonTrimmedBuffer.length() - this.buffer.length();
    }

    public String getNonTrimmedBuffer() {
        return this.nonTrimmedBuffer;
    }

    public int getCursor() {
        return this.cursor;
    }

    private void setCursor(int cursor) {
        this.cursor = cursor < 0 ? 0 : cursor;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setIgnoreOffset(boolean ignoreOffset) {
        this.ignoreOffset = ignoreOffset;
    }

    public boolean doIgnoreOffset() {
        return this.ignoreOffset;
    }

    public AeshContext getAeshContext() {
        return this.aeshContext;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public boolean hasAppendSeparator() {
        return this.appendSeparator;
    }

    public void doAppendSeparator(boolean appendSeparator) {
        this.appendSeparator = appendSeparator;
    }

    public List<TerminalString> getCompletionCandidates() {
        return this.completionCandidates;
    }

    public void setCompletionCandidates(List<String> completionCandidates) {
        this.addCompletionCandidates(completionCandidates);
    }

    public void setCompletionCandidatesTerminalString(List<TerminalString> completionCandidates) {
        this.completionCandidates = completionCandidates;
    }

    public void addCompletionCandidate(TerminalString completionCandidate) {
        this.completionCandidates.add(completionCandidate);
    }

    public void addCompletionCandidate(String completionCandidate) {
        this.addStringCandidate(completionCandidate);
    }

    public void addCompletionCandidates(List<String> completionCandidates) {
        this.addStringCandidates(completionCandidates);
    }

    public void addCompletionCandidatesTerminalString(List<TerminalString> completionCandidates) {
        this.completionCandidates.addAll(completionCandidates);
    }

    public void removeEscapedSpacesFromCompletionCandidates() {
        Parser.switchEscapedSpacesToSpacesInTerminalStringList(this.getCompletionCandidates());
    }

    private void addStringCandidate(String completionCandidate) {
        this.completionCandidates.add(new TerminalString(completionCandidate, true));
    }

    private void addStringCandidates(List<String> completionCandidates) {
        for (String s : completionCandidates) {
            this.addStringCandidate(s);
        }
    }

    public List<String> getFormattedCompletionCandidates() {
        ArrayList<String> fixedCandidates = new ArrayList<String>(this.completionCandidates.size());
        for (TerminalString c : this.completionCandidates) {
            if (!this.ignoreOffset && this.offset < this.cursor) {
                int pos = this.cursor - this.offset;
                if (c.getCharacters().length() >= pos) {
                    fixedCandidates.add(c.getCharacters().substring(pos));
                    continue;
                }
                fixedCandidates.add("");
                continue;
            }
            fixedCandidates.add(c.getCharacters());
        }
        return fixedCandidates;
    }

    public List<TerminalString> getFormattedCompletionCandidatesTerminalString() {
        ArrayList<TerminalString> fixedCandidates = new ArrayList<TerminalString>(this.completionCandidates.size());
        for (TerminalString c : this.completionCandidates) {
            if (!this.ignoreOffset && this.offset < this.cursor) {
                int pos = this.cursor - this.offset;
                if (c.getCharacters().length() >= pos) {
                    c.setCharacters(c.getCharacters().substring(pos));
                    fixedCandidates.add(c);
                    continue;
                }
                fixedCandidates.add(new TerminalString("", true));
                continue;
            }
            fixedCandidates.add(c);
        }
        return fixedCandidates;
    }

    public String getFormattedCompletion(String completion) {
        if (this.offset < this.cursor) {
            int pos = this.cursor - this.offset;
            if (completion.length() > pos) {
                return completion.substring(pos);
            }
            return "";
        }
        return completion;
    }

    public boolean isIgnoreStartsWith() {
        return this.ignoreStartsWith;
    }

    public void setIgnoreStartsWith(boolean ignoreStartsWith) {
        this.ignoreStartsWith = ignoreStartsWith;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Buffer: ").append(this.buffer).append(", Cursor:").append(this.cursor).append(", Offset:").append(this.offset).append(", IgnoreOffset:").append(this.ignoreOffset).append(", Append separator: ").append(this.appendSeparator).append(", Candidates:").append(this.completionCandidates);
        return sb.toString();
    }
}

