/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.File;
import java.io.IOException;
import org.jboss.aesh.console.AeshInputProcessor;
import org.jboss.aesh.console.CompletionHandler;
import org.jboss.aesh.console.ConsoleBuffer;
import org.jboss.aesh.console.InputProcessor;
import org.jboss.aesh.console.InputProcessorInterruptHook;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.history.FileHistory;
import org.jboss.aesh.history.History;
import org.jboss.aesh.history.InMemoryHistory;

public class AeshInputProcessorBuilder {
    private ConsoleBuffer consoleBuffer;
    private Settings settings;
    private History history;
    private CompletionHandler completion;
    private InputProcessorInterruptHook interruptHook;
    private boolean enableSearch = true;
    private boolean enableHistory = true;
    private boolean persistHistory = true;
    private File historyFile;
    private int historySize = 100;

    public AeshInputProcessorBuilder consoleBuffer(ConsoleBuffer consoleBuffer) {
        this.consoleBuffer = consoleBuffer;
        return this;
    }

    public AeshInputProcessorBuilder settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public AeshInputProcessorBuilder completion(CompletionHandler completion) {
        this.completion = completion;
        return this;
    }

    public AeshInputProcessorBuilder interruptHook(InputProcessorInterruptHook interruptHook) {
        this.interruptHook = interruptHook;
        return this;
    }

    public AeshInputProcessorBuilder enableHistory(boolean enableHistory) {
        this.enableHistory = enableHistory;
        return this;
    }

    public AeshInputProcessorBuilder persistHistory(boolean persistHistory) {
        this.persistHistory = persistHistory;
        return this;
    }

    public AeshInputProcessorBuilder historyFile(File historyFile) {
        this.historyFile = historyFile;
        return this;
    }

    public AeshInputProcessorBuilder historySize(int historySize) {
        this.historySize = historySize;
        return this;
    }

    public AeshInputProcessorBuilder enableSearch(boolean enableSearch) {
        this.enableSearch = enableSearch;
        return this;
    }

    public InputProcessor create() {
        try {
            if (this.consoleBuffer == null) {
                throw new IllegalArgumentException("ConsoleBuffer must be provided to create InputProcessor");
            }
            if (this.settings != null && !this.settings.isHistoryDisabled()) {
                if (this.settings != null) {
                    this.history = this.settings.isHistoryPersistent() ? new FileHistory(this.settings.getHistoryFile(), this.settings.getHistorySize()) : new InMemoryHistory(this.settings.getHistorySize());
                }
            } else {
                this.history = this.persistHistory && this.historyFile != null ? new FileHistory(this.historyFile, this.historySize) : new InMemoryHistory(this.historySize);
            }
            return new AeshInputProcessor(this.consoleBuffer, this.history, this.completion, this.interruptHook, this.enableHistory, this.enableSearch);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to create InputProcessor: " + e.getMessage());
        }
    }
}

