/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.settings;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.helper.InterruptHook;
import org.jboss.aesh.console.settings.QuitHandler;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsImpl;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.terminal.Terminal;

public class SettingsBuilder {
    SettingsImpl settings = new SettingsImpl();

    public SettingsBuilder() {
    }

    public SettingsBuilder(Settings baseSettings) {
        this.settings.setName(baseSettings.getName());
        this.settings.setMode(baseSettings.getMode());
        this.settings.setHistoryFile(baseSettings.getHistoryFile());
        this.settings.setHistorySize(baseSettings.getHistorySize());
        this.settings.setBellStyle(baseSettings.getBellStyle());
        this.settings.setAnsiConsole(baseSettings.isAnsiConsole());
        this.settings.setInputStream(baseSettings.getInputStream());
        this.settings.setStdOut(baseSettings.getStdOut());
        this.settings.setStdErr(baseSettings.getStdErr());
        this.settings.setTerminal(baseSettings.getTerminal());
        this.settings.setInputrc(baseSettings.getInputrc());
        this.settings.setLogging(baseSettings.isLogging());
        this.settings.setDisableCompletion(baseSettings.isDisableCompletion());
        this.settings.setLogFile(baseSettings.getLogFile());
        this.settings.setReadInputrc(baseSettings.doReadInputrc());
        this.settings.setHistoryDisabled(baseSettings.isHistoryDisabled());
        this.settings.setHistoryPersistent(baseSettings.isHistoryPersistent());
        this.settings.setReadAhead(baseSettings.isReadAhead());
        this.settings.setAliasFile(baseSettings.getAliasFile());
        this.settings.setAliasEnabled(baseSettings.isAliasEnabled());
        this.settings.setPersistAlias(baseSettings.doPersistAlias());
        this.settings.setQuitHandler(baseSettings.getQuitHandler());
        this.settings.setInterruptHook(baseSettings.getInterruptHook());
        this.settings.enableOperatorParser(baseSettings.isOperatorParserEnabled());
        this.settings.setManEnabled(baseSettings.isManEnabled());
        this.settings.setAeshContext(baseSettings.getAeshContext());
        this.settings.setExportEnabled(baseSettings.isExportEnabled());
        this.settings.setExportFile(baseSettings.getExportFile());
        this.settings.setPersistExport(baseSettings.doPersistExport());
        this.settings.setResource(baseSettings.getResource());
        this.settings.setExportUsesSystemEnvironment(baseSettings.doExportUsesSystemEnvironment());
    }

    public SettingsBuilder name(String name) {
        this.settings.setName(name);
        return this;
    }

    public SettingsBuilder mode(Mode mode) {
        this.settings.setMode(mode);
        return this;
    }

    public SettingsBuilder historyFile(File history) {
        this.settings.setHistoryFile(history);
        return this;
    }

    public SettingsBuilder historySize(int size) {
        this.settings.setHistorySize(size);
        return this;
    }

    public SettingsBuilder bellStyle(String bellStyle) {
        this.settings.setBellStyle(bellStyle);
        return this;
    }

    public SettingsBuilder ansi(boolean ansi) {
        this.settings.setAnsiConsole(ansi);
        return this;
    }

    public SettingsBuilder inputStream(InputStream inputStream) {
        this.settings.setInputStream(inputStream);
        return this;
    }

    public SettingsBuilder outputStream(PrintStream outputStream) {
        this.settings.setStdOut(outputStream);
        return this;
    }

    public SettingsBuilder outputStreamError(PrintStream error) {
        this.settings.setStdErr(error);
        return this;
    }

    public SettingsBuilder terminal(Terminal terminal) {
        this.settings.setTerminal(terminal);
        return this;
    }

    public SettingsBuilder inputrc(File inputrc) {
        this.settings.setInputrc(inputrc);
        return this;
    }

    public SettingsBuilder logging(boolean logging) {
        this.settings.setLogging(logging);
        return this;
    }

    public SettingsBuilder disableCompletion(boolean disableCompletion) {
        this.settings.setDisableCompletion(disableCompletion);
        return this;
    }

    public SettingsBuilder logfile(String logFile) {
        this.settings.setLogFile(logFile);
        return this;
    }

    public SettingsBuilder readInputrc(boolean readInputrc) {
        this.settings.setReadInputrc(readInputrc);
        return this;
    }

    public SettingsBuilder disableHistory(boolean disableHistory) {
        this.settings.setHistoryDisabled(disableHistory);
        return this;
    }

    public SettingsBuilder persistHistory(boolean persistHistory) {
        this.settings.setHistoryPersistent(persistHistory);
        return this;
    }

    public SettingsBuilder readAhead(boolean readAhead) {
        this.settings.setReadAhead(readAhead);
        return this;
    }

    public SettingsBuilder aliasFile(File aliasFile) {
        this.settings.setAliasFile(aliasFile);
        return this;
    }

    public SettingsBuilder enableAlias(boolean enableAlias) {
        this.settings.setAliasEnabled(enableAlias);
        return this;
    }

    public SettingsBuilder persistAlias(boolean persistAlias) {
        this.settings.setPersistAlias(persistAlias);
        return this;
    }

    public SettingsBuilder quitHandler(QuitHandler quitHandler) {
        this.settings.setQuitHandler(quitHandler);
        return this;
    }

    public SettingsBuilder interruptHook(InterruptHook interruptHook) {
        this.settings.setInterruptHook(interruptHook);
        return this;
    }

    public SettingsBuilder parseOperators(boolean parseOperators) {
        this.settings.enableOperatorParser(parseOperators);
        return this;
    }

    public SettingsBuilder enableMan(boolean enableMan) {
        this.settings.setManEnabled(enableMan);
        return this;
    }

    public SettingsBuilder aeshContext(AeshContext aeshContext) {
        this.settings.setAeshContext(aeshContext);
        return this;
    }

    public SettingsBuilder enableExport(boolean enableExport) {
        this.settings.setExportEnabled(enableExport);
        return this;
    }

    public SettingsBuilder exportFile(File exportFile) {
        this.settings.setExportFile(exportFile);
        return this;
    }

    public SettingsBuilder setPersistExport(boolean persistExport) {
        this.settings.setPersistExport(persistExport);
        return this;
    }

    public SettingsBuilder setExportUsesSystemEnvironment(boolean isLoad) {
        this.settings.setExportUsesSystemEnvironment(isLoad);
        return this;
    }

    public SettingsBuilder setFileResource(Resource resource) {
        this.settings.setResource(resource);
        return this;
    }

    public Settings create() {
        return this.settings;
    }
}

