/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit;

import org.jboss.aesh.edit.AbstractEditMode;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.KeyOperationManager;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.terminal.Key;

public class EmacsEditMode
extends AbstractEditMode {
    private Action mode = Action.EDIT;
    private final KeyOperationManager operationManager;

    public EmacsEditMode(KeyOperationManager operations) {
        this.operationManager = operations;
    }

    @Override
    public Operation parseInput(Key in, String buffer) {
        if (this.isAskingForCompletions()) {
            if (in == Key.y) {
                this.setAskForCompletions(false);
                return Operation.COMPLETE;
            }
            if (in == Key.n) {
                this.setAskForCompletions(false);
                return Operation.COMPLETE_ABORT;
            }
            return Operation.NO_ACTION;
        }
        KeyOperation currentOperation = this.operationManager.findOperation(in);
        if (currentOperation != null) {
            return this.findOperation(currentOperation, buffer);
        }
        if (this.mode == Action.SEARCH) {
            if (in == Key.ESC) {
                this.mode = Action.EDIT;
                return Operation.SEARCH_EXIT;
            }
            return Operation.SEARCH_INPUT;
        }
        if (in == Key.ESC) {
            return Operation.NO_ACTION;
        }
        return Operation.EDIT;
    }

    private Operation findOperation(KeyOperation currentOperation, String buffer) {
        if (this.mode == Action.SEARCH) {
            if (currentOperation.getOperation() == Operation.NEW_LINE) {
                this.mode = Action.EDIT;
                return Operation.SEARCH_END;
            }
            if (currentOperation.getOperation() == Operation.SEARCH_PREV) {
                return Operation.SEARCH_PREV_WORD;
            }
            if (currentOperation.getOperation() == Operation.SEARCH_NEXT_WORD) {
                return Operation.SEARCH_NEXT_WORD;
            }
            if (currentOperation.getOperation() == Operation.DELETE_PREV_CHAR) {
                return Operation.SEARCH_DELETE;
            }
            return Operation.SEARCH_INPUT;
        }
        Operation operation = currentOperation.getOperation();
        if (operation == Operation.SEARCH_PREV || operation == Operation.SEARCH_NEXT_WORD) {
            this.mode = Action.SEARCH;
        }
        if (currentOperation.getOperation() == Operation.EOF) {
            if (buffer.isEmpty()) {
                this.checkEof();
                ++this.eofCounter;
                if (this.eofCounter > this.ignoreEof) {
                    return currentOperation.getOperation();
                }
                return Operation.IGNOREEOF;
            }
            return Operation.DELETE_NEXT_CHAR;
        }
        return operation;
    }

    @Override
    public Action getCurrentAction() {
        return this.mode;
    }

    @Override
    public Mode getMode() {
        return Mode.EMACS;
    }
}

