/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.beans;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.Property;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.PropertySource;
import org.jboss.forge.roaster.model.util.Refactory;
import org.jboss.forge.roaster.model.util.Types;

public class FieldOperations {
    public void removeField(JavaClassSource targetClass, Field<JavaClassSource> field) {
        PropertySource property = targetClass.getProperty(field.getName());
        property.setMutable(false).setAccessible(false);
        targetClass.removeProperty((Property)property);
        this.updateToString(targetClass);
    }

    public FieldSource<JavaClassSource> addFieldTo(JavaClassSource targetClass, String fieldType, String fieldName, String ... annotations) {
        return this.addFieldTo(targetClass, fieldType, fieldName, Visibility.PRIVATE, true, true, annotations);
    }

    public FieldSource<JavaClassSource> addFieldTo(JavaClassSource targetClass, String fieldType, String fieldName, Visibility visibility, boolean withGetter, boolean withSetter, String ... annotations) {
        if (targetClass.hasField(fieldName)) {
            throw new IllegalStateException("Entity already has a field named [" + fieldName + "]");
        }
        PropertySource property = targetClass.addProperty(fieldType, fieldName);
        FieldSource field = property.getField();
        field.setVisibility(visibility);
        for (String annotation : annotations) {
            field.addAnnotation(annotation);
        }
        String fieldTypeForImport = Types.stripArray((String)fieldType);
        if (!fieldTypeForImport.startsWith("java.lang.") && fieldTypeForImport.contains(".") && !fieldTypeForImport.equals(targetClass.getCanonicalName())) {
            targetClass.addImport(fieldTypeForImport);
        }
        if (!withGetter) {
            targetClass.removeMethod((Method)property.getAccessor());
        }
        if (!withSetter) {
            targetClass.removeMethod((Method)property.getMutator());
        }
        this.updateToString(targetClass);
        return field;
    }

    private void updateToString(JavaClassSource targetEntity) {
        if (targetEntity.hasMethodSignature("toString")) {
            targetEntity.removeMethod((Method)targetEntity.getMethod("toString"));
        }
        ArrayList<FieldSource> fields = new ArrayList<FieldSource>();
        for (FieldSource f : targetEntity.getFields()) {
            if (!this.canAddFieldToToString((Field<JavaClassSource>)f)) continue;
            fields.add(f);
        }
        if (!fields.isEmpty()) {
            Refactory.createToStringFromFields((JavaClassSource)targetEntity, fields);
        }
    }

    protected boolean canAddFieldToToString(Field<JavaClassSource> field) {
        return !field.isStatic();
    }

    public boolean isFieldTypeEnum(Project project, String fieldType) {
        return this.isFieldTypeEnum(project, null, fieldType);
    }

    public boolean isFieldTypeEnum(Project project, JavaClassSource targetEntity, String fieldType) {
        boolean isEnum = false;
        Assert.notNull((Object)fieldType, (String)"Field type should not be null");
        Assert.notNull((Object)project, (String)"Field project should not be null");
        try {
            isEnum = ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getJavaResource(fieldType).getJavaType().isEnum();
        }
        catch (FileNotFoundException | ResourceException e1) {
            try {
                if (targetEntity != null) {
                    isEnum = ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getJavaResource(targetEntity.getPackage() + "." + fieldType).getJavaType().isEnum();
                }
            }
            catch (FileNotFoundException | ResourceException e2) {
                // empty catch block
            }
        }
        return isEnum;
    }
}

