/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class TypeParameterDeclaration
extends AstNode {
    public static final Role<Annotation> ANNOTATION_ROLE = EntityDeclaration.ANNOTATION_ROLE;

    public TypeParameterDeclaration() {
    }

    public TypeParameterDeclaration(String name) {
        this.setName(name);
    }

    public final AstNodeCollection<Annotation> getAnnotations() {
        return this.getChildrenByRole(ANNOTATION_ROLE);
    }

    public final String getName() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setName(String value) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
    }

    public final AstType getExtendsBound() {
        return this.getChildByRole(Roles.EXTENDS_BOUND);
    }

    public final void setExtendsBound(AstType value) {
        this.setChildByRole(Roles.EXTENDS_BOUND, value);
    }

    public final Identifier getNameToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setNameToken(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitTypeParameterDeclaration(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof TypeParameterDeclaration) {
            TypeParameterDeclaration otherDeclaration = (TypeParameterDeclaration)other;
            return !otherDeclaration.isNull() && TypeParameterDeclaration.matchString(this.getName(), otherDeclaration.getName()) && this.getExtendsBound().matches(otherDeclaration.getExtendsBound(), match) && this.getAnnotations().matches(otherDeclaration.getAnnotations(), match);
        }
        return false;
    }
}

