/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui.methods;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.parser.java.beans.ProjectOperations;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.ui.methods.BuilderGetSetMethodGenerator;
import org.jboss.forge.addon.parser.java.ui.methods.DefaultGetSetMethodGenerator;
import org.jboss.forge.addon.parser.java.ui.methods.JavaGetSetMethodsCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.PropertySource;

public class JavaGetSetMethodsCommandImpl
extends AbstractProjectCommand
implements JavaGetSetMethodsCommand {
    @Inject
    @WithAttributes(label="Target Class", description="The class where the field will be created", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetClass;
    @Inject
    @WithAttributes(label="Use builder pattern", description="Use builder pattern for generating accessor and mutator methods", defaultValue="false")
    private UIInput<Boolean> builderPattern;
    @Inject
    @WithAttributes(label="Java properties", description="Properties, for which the get/set methods should be generated", required=true)
    private UISelectMany<String> properties;
    @Inject
    private ProjectOperations projectOperations;
    @Inject
    private ProjectFactory projectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: Generate Getters and Setters").description("Generates mutators and accessors for the given class").category(Categories.create((String[])new String[]{"Java"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupTargetClass(builder.getUIContext());
        this.properties.setValueChoices((Callable)new Callable<Iterable<String>>(){

            @Override
            public Iterable<String> call() throws Exception {
                ArrayList<String> strings = new ArrayList<String>();
                JavaResource javaResource = (JavaResource)JavaGetSetMethodsCommandImpl.this.targetClass.getValue();
                JavaClassSource targetClass = (JavaClassSource)javaResource.getJavaType();
                List properties = targetClass.getProperties();
                for (PropertySource property : properties) {
                    strings.add(property.getName());
                }
                return strings;
            }
        });
        this.properties.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return JavaGetSetMethodsCommandImpl.this.targetClass.getValue() != null;
            }
        });
        builder.add(this.targetClass).add(this.builderPattern).add(this.properties);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaResource javaResource = (JavaResource)this.targetClass.getValue();
        JavaClassSource targetClass = (JavaClassSource)javaResource.getJavaType();
        DefaultGetSetMethodGenerator generator = (Boolean)this.builderPattern.getValue() != false ? new BuilderGetSetMethodGenerator() : new DefaultGetSetMethodGenerator();
        ArrayList<PropertySource> selectedProperties = new ArrayList<PropertySource>();
        if (this.properties == null || this.properties.getValue() == null) {
            return Results.fail((String)"No properties were selected");
        }
        for (String selectedProperty : this.properties.getValue()) {
            selectedProperties.add(targetClass.getProperty(selectedProperty));
        }
        for (PropertySource property : selectedProperties) {
            MethodSource accessor = targetClass.getMethod("get" + Strings.capitalize((String)property.getName()));
            if (accessor == null) {
                generator.createAccessor(property);
            } else if (!generator.isCorrectAccessor(accessor, property) && this.promptToFixMethod(context, accessor.getName(), property.getName())) {
                targetClass.removeMethod((Method)accessor);
                generator.createMutator(property);
            }
            String mutatorMethodName = "set" + Strings.capitalize((String)property.getName());
            String mutatorMethodParameter = property.getType().getName();
            MethodSource mutator = targetClass.getMethod(mutatorMethodName, new String[]{mutatorMethodParameter});
            if (mutator == null) {
                generator.createMutator(property);
                continue;
            }
            if (generator.isCorrectMutator(mutator, property) || !this.promptToFixMethod(context, mutator.getName(), property.getName())) continue;
            targetClass.removeMethod((Method)mutator);
            generator.createMutator(property);
        }
        this.setCurrentWorkingResource(context, targetClass);
        return Results.success((String)"Mutators and accessors were generated successfully");
    }

    private boolean promptToFixMethod(UIExecutionContext context, String methodName, String propertyName) {
        UIPrompt prompt = context.getPrompt();
        return prompt.promptBoolean("Method '" + methodName + "'already exists for property" + propertyName + " . Method is not following the selected pattern." + " Should it be fixed?");
    }

    private void setupTargetClass(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        List entities = this.projectOperations.getProjectClasses(project);
        this.targetClass.setValueChoices((Iterable)entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx != -1) {
            this.targetClass.setDefaultValue(entities.get(idx));
        }
    }

    private void setCurrentWorkingResource(UIExecutionContext context, JavaClassSource javaClass) throws FileNotFoundException {
        Project selectedProject = this.getSelectedProject((UIContextProvider)context);
        if (selectedProject != null) {
            JavaSourceFacet facet = (JavaSourceFacet)selectedProject.getFacet(JavaSourceFacet.class);
            facet.saveJavaSource((JavaSource)javaClass);
        }
        context.getUIContext().setSelection((Object)javaClass);
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

