/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.IteratingRuleProvider;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.HibernateConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.service.HibernateConfigurationFileService;
import org.jboss.windup.rules.apps.xml.DiscoverXmlFilesRuleProvider;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverHibernateConfigurationRuleProvider
extends IteratingRuleProvider<DoctypeMetaModel> {
    private static final String TECH_TAG = "Hibernate Cfg";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;
    private static final String hibernateRegex = "(?i).*hibernate.configuration.*";

    public RulePhase getPhase() {
        return RulePhase.DISCOVERY;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{DiscoverXmlFilesRuleProvider.class});
    }

    public String toStringPerform() {
        return "Discover hibernate.cfg.xml files";
    }

    public ConditionBuilder when() {
        QueryGremlinCriterion doctypeSearchCriterion = new QueryGremlinCriterion(){

            public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
                pipeline.has("publicId", (Predicate)Text.REGEX, (Object)DiscoverHibernateConfigurationRuleProvider.hibernateRegex);
                FramedGraphQuery systemIDQuery = event.getGraphContext().getQuery().type(DoctypeMetaModel.class).has("systemId", (Predicate)Text.REGEX, (Object)DiscoverHibernateConfigurationRuleProvider.hibernateRegex);
                GremlinPipeline systemIdPipeline = new GremlinPipeline((Object)systemIDQuery.vertices());
                pipeline.add((Pipe)systemIdPipeline);
                pipeline.dedup();
            }
        };
        return Query.find(DoctypeMetaModel.class).piped(doctypeSearchCriterion);
    }

    public void perform(GraphRewrite event, EvaluationContext context, DoctypeMetaModel payload) {
        HibernateConfigurationFileService hibernateConfigurationFileService = new HibernateConfigurationFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        String publicId = payload.getPublicId();
        String systemId = payload.getSystemId();
        String versionInformation = this.extractVersion(publicId, systemId);
        for (XmlFileModel xml : payload.getXmlResources()) {
            HibernateConfigurationFileModel hibernateCfgModel = (HibernateConfigurationFileModel)hibernateConfigurationFileService.addTypeToModel((WindupVertexFrame)xml);
            technologyTagService.addTagToFileModel((FileModel)hibernateCfgModel, TECH_TAG, TECH_TAG_LEVEL);
            if (!StringUtils.isNotBlank((String)versionInformation)) continue;
            hibernateCfgModel.setSpecificationVersion(versionInformation);
        }
    }

    private String extractVersion(String publicId, String systemId) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("[0-9][0-9a-zA-Z.-]+");
        if (StringUtils.isNotBlank((String)publicId) && (matcher = pattern.matcher(publicId)).find()) {
            return matcher.group();
        }
        if (StringUtils.isNotBlank((String)systemId) && (matcher = pattern.matcher(systemId)).find()) {
            String match = matcher.group();
            return StringUtils.removeEnd((String)match, (String)".dtd");
        }
        return null;
    }
}

