/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.legacy.java;

import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.config.Hint;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.scan.ast.TypeReferenceLocation;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderPerform;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.Context;

public class Config
extends WindupRuleProvider {
    public void enhanceMetadata(Context context) {
        super.enhanceMetadata(context);
        context.put((Object)RuleMetadata.CATEGORY, (Object)"Java");
    }

    public Configuration getConfiguration(GraphContext context) {
        ConfigurationRuleBuilderPerform configuration = ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"edu.oswego.cs.dl.util.concurrent")).perform((Operation)Hint.withText((String)"Upgrade to javax.util.concurrent in Java 5+").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"edu.emory.mathcs.backport.java.util")).perform((Operation)Hint.withText((String)"Upgrade to javax.util.concurrent in Java 5+").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"java.lang.Class.classForName").at(new TypeReferenceLocation[]{TypeReferenceLocation.METHOD})).perform((Operation)Hint.withText((String)"Ensure class is available to JBoss").withEffort(1)).addRule().when((Condition)JavaClass.references((String)"oracle.sql.*").at(new TypeReferenceLocation[]{TypeReferenceLocation.TYPE})).perform((Operation)Hint.withText((String)"Oracle-specific SQL code").withEffort(1)).addRule().when((Condition)JavaClass.references((String)"org.osoa.sca.annotations.+").at(new TypeReferenceLocation[]{TypeReferenceLocation.IMPORT})).perform((Operation)Hint.withText((String)"Remove import").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"org.osoa.sca.annotations.Property").at(new TypeReferenceLocation[]{TypeReferenceLocation.TYPE})).perform((Operation)Hint.withText((String)"SCA Property Injection; replace with Spring Property Injection").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"org.osoa.sca.annotations.Reference").at(new TypeReferenceLocation[]{TypeReferenceLocation.TYPE})).perform((Operation)Hint.withText((String)"SCA Bean Injection; replace with Spring Bean Injection").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"org.osoa.sca.annotations.Init").at(new TypeReferenceLocation[]{TypeReferenceLocation.TYPE})).perform((Operation)Hint.withText((String)"SCA Initialization Hook; Use the property: init-method='example' on the Spring Bean, where example is the initialization method").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"org.osoa.sca.annotations.Destroy").at(new TypeReferenceLocation[]{TypeReferenceLocation.TYPE})).perform((Operation)Hint.withText((String)"SCA Destroy Hook; Use the property: destroy-method='example' on the Spring Bean, where example is the destroy method").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"com.ibm.ctg.client.JavaGateway").at(new TypeReferenceLocation[]{TypeReferenceLocation.TYPE})).perform((Operation)Hint.withText((String)"IBM CICS Adapter").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"((javax.naming.InitialContext)|(javax.naming.Context)).lookup").at(new TypeReferenceLocation[]{TypeReferenceLocation.METHOD})).perform((Operation)Hint.withText((String)"<![CDATA[\n                Ensure that the JNDI Name does not need to change for JBoss\n                \n                *For Example:*\n                \n                ```java\n                (ConnectionFactory)initialContext.lookup(\"weblogic.jms.ConnectionFactory\");\n                ```\n                \n                *should become:*\n                \n                ```java\n                (ConnectionFactory)initialContext.lookup(\"/ConnectionFactory\");\n                ```\n                \n                \n                ]]>").withEffort(1)).addRule().when((Condition)JavaClass.references((String)"javax.naming.InitialContext\\(.+\\)").at(new TypeReferenceLocation[]{TypeReferenceLocation.CONSTRUCTOR_CALL})).perform((Operation)Hint.withText((String)"Ensure that the InitialContext connection properties do not need to change for JBoss").withEffort(1)).addRule().when((Condition)JavaClass.references((String)"javax.management.remote.JMXServiceURL\\(.+\\)").at(new TypeReferenceLocation[]{TypeReferenceLocation.CONSTRUCTOR_CALL})).perform((Operation)Hint.withText((String)"Ensure that the connection properties do not need to change for JBoss").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"javax.management.ObjectName\\(.+\\)").at(new TypeReferenceLocation[]{TypeReferenceLocation.CONSTRUCTOR_CALL})).perform((Operation)Hint.withText((String)"Ensure that the ObjectName exists in JBoss").withEffort(1)).addRule().when((Condition)JavaClass.references((String)"javax.management.remote.JMXConnectorFactory.connect\\(.+\\)").at(new TypeReferenceLocation[]{TypeReferenceLocation.METHOD})).perform((Operation)Hint.withText((String)"Ensure that the connection properties do not need to change for JBoss").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"java.sql.DriverManager").at(new TypeReferenceLocation[]{TypeReferenceLocation.METHOD})).perform((Operation)Hint.withText((String)"Move to a JCA Connector unless this class is used for batch processes, then refactor as necessary").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"java.sql.DriverManager$").at(new TypeReferenceLocation[]{TypeReferenceLocation.IMPORT})).perform((Operation)Hint.withText((String)"Migrate to JCA Connector").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"amx_.+").at(new TypeReferenceLocation[]{TypeReferenceLocation.IMPORT})).perform((Operation)Hint.withText((String)"Tibco ActiveMatrix Stub; regenerate the SOAP Client for the class").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"com.tibco.matrix.java.annotations.WebParam$")).perform((Operation)Hint.withText((String)"Tibco specific annotation; replace with javax.jws.WebParam").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"com.tibco.amf.platform.runtime.extension.exception.SOAPCode$")).perform((Operation)Hint.withText((String)"Tibco specific annotation").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"com.tibco.matrix.java.annotations.WebServiceInterface$")).perform((Operation)Hint.withText((String)"Tibco specific annotation; replace with javax.jws.WebService").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"com.tibco.matrix.java.annotations.WebMethod$")).perform((Operation)Hint.withText((String)"Tibco specific annotation; replace with javax.jws.WebMethod").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"com.tibco.matrix.java.annotations.WebFault$")).perform((Operation)Hint.withText((String)"Tibco specific annotation; replace with javax.xml.ws.WebFault").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"org.mule.transformers.AbstractTransformer$")).perform((Operation)Hint.withText((String)"Mule specific; replace with org.apache.camel.Converter annotation").withEffort(0)).addRule().when((Condition)JavaClass.references((String)"org.mule.umo.UMOMessage.getPayload.+").at(new TypeReferenceLocation[]{TypeReferenceLocation.METHOD})).perform((Operation)Hint.withText((String)"Mule specific; replace with org.apache.camel.Message.getBody()").withEffort(0));
        return configuration;
    }
}

