/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.QueryResults;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.BooleanQueryResultParserFactory;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.BooleanQueryResultWriter;
import org.openrdf.query.resultio.BooleanQueryResultWriterFactory;
import org.openrdf.query.resultio.BooleanQueryResultWriterRegistry;
import org.openrdf.query.resultio.QueryResultFormat;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.QueryResultWriter;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserFactory;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.query.resultio.helpers.QueryResultCollector;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;

public class QueryResultIO {
    public static TupleQueryResultFormat getParserFormatForMIMEType(String mimeType) {
        return (TupleQueryResultFormat)TupleQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType, null);
    }

    public static TupleQueryResultFormat getParserFormatForMIMEType(String mimeType, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType, fallback);
    }

    public static TupleQueryResultFormat getParserFormatForFileName(String fileName) {
        return (TupleQueryResultFormat)TupleQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static TupleQueryResultFormat getParserFormatForFileName(String fileName, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName, fallback);
    }

    public static TupleQueryResultFormat getWriterFormatForMIMEType(String mimeType) {
        return (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static TupleQueryResultFormat getWriterFormatForMIMEType(String mimeType, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType, fallback);
    }

    public static TupleQueryResultFormat getWriterFormatForFileName(String fileName) {
        return (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static TupleQueryResultFormat getWriterFormatForFileName(String fileName, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName, fallback);
    }

    public static BooleanQueryResultFormat getBooleanParserFormatForMIMEType(String mimeType) {
        return (BooleanQueryResultFormat)BooleanQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType, null);
    }

    public static BooleanQueryResultFormat getBooleanParserFormatForMIMEType(String mimeType, BooleanQueryResultFormat fallback) {
        return (BooleanQueryResultFormat)BooleanQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType, fallback);
    }

    public static BooleanQueryResultFormat getBooleanParserFormatForFileName(String fileName) {
        return (BooleanQueryResultFormat)BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static BooleanQueryResultFormat getBooleanParserFormatForFileName(String fileName, BooleanQueryResultFormat fallback) {
        return (BooleanQueryResultFormat)BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName, fallback);
    }

    public static BooleanQueryResultFormat getBooleanWriterFormatForMIMEType(String mimeType) {
        return (BooleanQueryResultFormat)BooleanQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static BooleanQueryResultFormat getBooleanWriterFormatForMIMEType(String mimeType, BooleanQueryResultFormat fallback) {
        return (BooleanQueryResultFormat)BooleanQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType, fallback);
    }

    public static BooleanQueryResultFormat getBooleanWriterFormatForFileName(String fileName) {
        return (BooleanQueryResultFormat)BooleanQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static BooleanQueryResultFormat getBooleanWriterFormatForFileName(String fileName, BooleanQueryResultFormat fallback) {
        return (BooleanQueryResultFormat)BooleanQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName, fallback);
    }

    public static TupleQueryResultParser createParser(TupleQueryResultFormat format) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParserFactory factory = (TupleQueryResultParserFactory)TupleQueryResultParserRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getParser();
        }
        throw new UnsupportedQueryResultFormatException("No parser factory available for tuple query result format " + (Object)((Object)format));
    }

    public static TupleQueryResultParser createParser(TupleQueryResultFormat format, ValueFactory valueFactory) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser(format);
        parser.setValueFactory(valueFactory);
        return parser;
    }

    public static TupleQueryResultWriter createWriter(TupleQueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getWriter(out);
        }
        throw new UnsupportedQueryResultFormatException("No writer factory available for tuple query result format " + (Object)((Object)format));
    }

    public static BooleanQueryResultParser createParser(BooleanQueryResultFormat format) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultParserFactory factory = (BooleanQueryResultParserFactory)BooleanQueryResultParserRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getParser();
        }
        throw new UnsupportedQueryResultFormatException("No parser factory available for boolean query result format " + (Object)((Object)format));
    }

    public static BooleanQueryResultWriter createWriter(BooleanQueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultWriterFactory factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getWriter(out);
        }
        throw new UnsupportedQueryResultFormatException("No writer factory available for boolean query result format " + (Object)((Object)format));
    }

    public static QueryResultWriter createWriter(QueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultWriterFactory factory;
        if (format instanceof TupleQueryResultFormat) {
            TupleQueryResultWriterFactory factory2 = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((Object)((TupleQueryResultFormat)format));
            if (factory2 != null) {
                return factory2.getWriter(out);
            }
        } else if (format instanceof BooleanQueryResultFormat && (factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((Object)((BooleanQueryResultFormat)format))) != null) {
            return factory.getWriter(out);
        }
        throw new UnsupportedQueryResultFormatException("No writer factory available for query result format " + (Object)((Object)format));
    }

    public static void parse(InputStream in, TupleQueryResultFormat format, TupleQueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser(format);
        parser.setValueFactory(valueFactory);
        parser.setQueryResultHandler((QueryResultHandler)handler);
        try {
            parser.parseQueryResult(in);
        }
        catch (QueryResultHandlerException e) {
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public static TupleQueryResult parse(InputStream in, TupleQueryResultFormat format) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser(format);
        TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
        parser.setQueryResultHandler((QueryResultHandler)qrBuilder);
        try {
            parser.parseQueryResult(in);
        }
        catch (QueryResultHandlerException e) {
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
        return qrBuilder.getQueryResult();
    }

    public static boolean parse(InputStream in, BooleanQueryResultFormat format) throws IOException, QueryResultParseException, UnsupportedQueryResultFormatException {
        BooleanQueryResultParser parser = QueryResultIO.createParser(format);
        try {
            QueryResultCollector handler = new QueryResultCollector();
            parser.setQueryResultHandler(handler);
            parser.parseQueryResult(in);
            if (handler.getHandledBoolean()) {
                return handler.getBoolean();
            }
            throw new QueryResultParseException("Did not find a boolean result");
        }
        catch (QueryResultHandlerException e) {
            throw new QueryResultParseException(e);
        }
    }

    public static void write(TupleQueryResult tqr, TupleQueryResultFormat format, OutputStream out) throws IOException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        TupleQueryResultWriter writer = QueryResultIO.createWriter(format, out);
        try {
            writer.startDocument();
            writer.startHeader();
            QueryResults.report((TupleQueryResult)tqr, (QueryResultHandler)writer);
        }
        catch (QueryResultHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    @Deprecated
    public static void write(boolean value, BooleanQueryResultFormat format, OutputStream out) throws IOException, UnsupportedQueryResultFormatException {
        BooleanQueryResultWriter writer = QueryResultIO.createWriter(format, out);
        try {
            writer.startDocument();
            writer.startHeader();
        }
        catch (QueryResultHandlerException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        writer.write(value);
    }

    public static void writeBoolean(boolean value, BooleanQueryResultFormat format, OutputStream out) throws QueryResultHandlerException, UnsupportedQueryResultFormatException {
        BooleanQueryResultWriter writer = QueryResultIO.createWriter(format, out);
        writer.startDocument();
        writer.startHeader();
        writer.handleBoolean(value);
    }

    public static void write(GraphQueryResult gqr, RDFFormat format, OutputStream out) throws IOException, RDFHandlerException, UnsupportedRDFormatException, QueryEvaluationException {
        RDFWriter writer = Rio.createWriter((RDFFormat)format, (OutputStream)out);
        try {
            QueryResults.report((GraphQueryResult)gqr, (RDFHandler)writer);
        }
        catch (RDFHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }
}

