/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectAssociationProvider;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.furnace.util.Strings;

public class MavenMultiModuleProvider
implements ProjectAssociationProvider {
    @Inject
    private ProjectFactory projectFactory;

    public void associate(Project project, Resource<?> parentResource) {
        Project parent;
        MavenFacet parentMavenFacet;
        Model parentPom;
        if (this.canAssociate(project, parentResource) && (parentPom = (parentMavenFacet = (MavenFacet)(parent = this.projectFactory.findProject(parentResource)).getFacet(MavenFacet.class)).getModel()).getPackaging().equalsIgnoreCase("pom")) {
            String moduleDir = project.getRoot().getFullyQualifiedName().substring(parent.getRoot().getFullyQualifiedName().length());
            if (moduleDir.startsWith(File.separator)) {
                moduleDir = moduleDir.substring(1);
            }
            parentPom.addModule(moduleDir);
            parentMavenFacet.setModel(parentPom);
            MavenFacet projectMavenFacet = (MavenFacet)project.getFacet(MavenFacet.class);
            Model pom = projectMavenFacet.getModel();
            Parent projectParent = new Parent();
            projectParent.setGroupId(parentPom.getGroupId());
            projectParent.setArtifactId(parentPom.getArtifactId());
            String version = this.resolveVersion(parentPom);
            projectParent.setVersion(version);
            Path parentPomPath = Paths.get(parentMavenFacet.getModelResource().getFullyQualifiedName(), new String[0]);
            Path childPath = Paths.get(project.getRoot().getFullyQualifiedName(), new String[0]);
            Path relativePath = childPath.relativize(parentPomPath).normalize();
            projectParent.setRelativePath(relativePath.toString());
            pom.setGroupId(null);
            pom.setVersion(null);
            pom.setParent(projectParent);
            projectMavenFacet.setModel(pom);
        }
    }

    private String resolveVersion(Model parent) {
        String version = parent.getVersion();
        if (Strings.isNullOrEmpty((String)version) && parent.getParent() != null && !Strings.isNullOrEmpty((String)parent.getParent().getVersion())) {
            version = parent.getParent().getVersion();
        }
        return version;
    }

    public boolean canAssociate(Project project, Resource<?> parent) {
        return parent.getChild("pom.xml").exists() && project.getRoot().getChild("pom.xml").exists();
    }
}

