/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.archetype.ui;

import java.io.File;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.maven.projects.archetype.ArchetypeHelper;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.util.Strings;

public class ArchetypeSelectionWizardStep
extends AbstractUICommand
implements UIWizardStep {
    @Inject
    @WithAttributes(label="Archetype Group Id", required=true)
    private UIInput<String> archetypeGroupId;
    @Inject
    @WithAttributes(label="Archetype Artifact Id", required=true)
    private UIInput<String> archetypeArtifactId;
    @Inject
    @WithAttributes(label="Archetype Version", required=true)
    private UIInput<String> archetypeVersion;
    @Inject
    @WithAttributes(label="Archetype repository URL")
    private UIInput<String> archetypeRepository;
    @Inject
    private DependencyResolver resolver;

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Maven: Choose Archetype").description("Enter a Maven archetype coordinate");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.archetypeGroupId).add(this.archetypeArtifactId).add(this.archetypeVersion).add(this.archetypeRepository);
    }

    public void validate(UIValidationContext validator) {
        String repository = (String)this.archetypeRepository.getValue();
        if (!Strings.isNullOrEmpty((String)repository) && !Strings.isURL((String)repository)) {
            validator.addValidationError(this.archetypeRepository, "Archetype repository must be a valid URL");
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = (Project)uiContext.getAttributeMap().get(Project.class);
        String coordinate = (String)this.archetypeGroupId.getValue() + ":" + (String)this.archetypeArtifactId.getValue() + ":" + (String)this.archetypeVersion.getValue();
        DependencyQueryBuilder depQuery = DependencyQueryBuilder.create((String)coordinate);
        String repository = (String)this.archetypeRepository.getValue();
        if (repository != null) {
            depQuery.setRepositories(new DependencyRepository[]{new DependencyRepository("archetype", repository)});
        }
        Dependency resolvedArtifact = this.resolver.resolveArtifact((DependencyQuery)depQuery);
        FileResource artifact = resolvedArtifact.getArtifact();
        MetadataFacet metadataFacet = (MetadataFacet)project.getFacet(MetadataFacet.class);
        File fileRoot = (File)((DirectoryResource)project.getRoot().reify(DirectoryResource.class)).getUnderlyingResourceObject();
        ArchetypeHelper archetypeHelper = new ArchetypeHelper(artifact.getResourceInputStream(), fileRoot, metadataFacet.getProjectGroupName(), metadataFacet.getProjectName(), metadataFacet.getProjectVersion());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        archetypeHelper.setPackageName(facet.getBasePackage());
        archetypeHelper.execute();
        return Results.success();
    }
}

