/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.facets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.ProjectBuildingResult;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.dependencies.util.Dependencies;
import org.jboss.forge.addon.dependencies.util.NonSnapshotDependencyFilter;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.dependencies.MavenDependencyAdapter;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenFacetImpl;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.furnace.util.Predicate;

@Dependent
@FacetConstraint(value={MavenFacet.class})
public class MavenDependencyFacet
extends AbstractFacet<Project>
implements DependencyFacet {
    private static final Logger log = Logger.getLogger(MavenDependencyFacet.class.getName());
    @Inject
    private DependencyResolver resolver;

    public boolean isInstalled() {
        return ((Project)this.getFaceted()).hasFacet(MavenFacet.class);
    }

    public boolean install() {
        return true;
    }

    public void addDirectDependency(Dependency dep) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        List dependencies = pom.getDependencies();
        Coordinate depCoordinate = dep.getCoordinate();
        boolean exists = false;
        for (org.apache.maven.model.Dependency dependency : dependencies) {
            if (!dependency.getGroupId().equals(depCoordinate.getGroupId()) || !dependency.getArtifactId().equals(depCoordinate.getArtifactId())) continue;
            dependency.setVersion(depCoordinate.getVersion());
            exists = true;
        }
        if (!exists) {
            org.apache.maven.model.Dependency dependency = (org.apache.maven.model.Dependency)MavenDependencyAdapter.toMavenList(Arrays.asList(dep)).get(0);
            dependencies.add(dependency);
        }
        maven.setModel(pom);
    }

    public boolean hasDirectDependency(Dependency dependency) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        for (Dependency dep : dependencies) {
            if (!Dependencies.areEquivalent((Dependency)this.resolveProperties(dependency), (Dependency)dep)) continue;
            return true;
        }
        return false;
    }

    public void removeDependency(Dependency dep) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        ArrayList<Dependency> toBeRemoved = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            if (!Dependencies.areEquivalent((Dependency)dependency, (Dependency)this.resolveProperties(dep))) continue;
            toBeRemoved.add(dependency);
        }
        dependencies.removeAll(toBeRemoved);
        pom.setDependencies(MavenDependencyAdapter.toMavenList((List)dependencies));
        maven.setModel(pom);
    }

    public List<Dependency> getDependencies() {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            result.add(this.resolveProperties(dependency));
        }
        return result;
    }

    public Dependency getDirectDependency(Dependency dependency) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        for (Dependency dep : dependencies) {
            if (!Dependencies.areEquivalent((Dependency)this.resolveProperties(dependency), (Dependency)dep)) continue;
            return this.resolveProperties(dep);
        }
        return null;
    }

    public boolean hasEffectiveDependency(Dependency dependency) {
        return this.getEffectiveDependency(this.resolveProperties(dependency)) != null;
    }

    public Dependency getEffectiveDependency(Dependency manDep) {
        for (Dependency dependency : this.getEffectiveDependencies()) {
            if (!Dependencies.areEquivalent((Dependency)dependency, (Dependency)this.resolveProperties(manDep))) continue;
            return this.resolveProperties(dependency);
        }
        return null;
    }

    public List<Dependency> getEffectiveDependencies() {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        MavenFacetImpl maven = (MavenFacetImpl)((Project)this.getFaceted()).getFacet(MavenFacetImpl.class);
        try {
            ProjectBuildingResult projectBuildingResult = maven.getProjectBuildingResult();
            DependencyResolutionResult dependencyResolutionResult = projectBuildingResult.getDependencyResolutionResult();
            List deps = MavenDependencyAdapter.fromAetherList((List)dependencyResolutionResult.getDependencies());
            for (Dependency dependency : deps) {
                result.add(this.resolveProperties(dependency));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not resolve managed dependencies in project [" + maven.getModelResource().getFullyQualifiedName() + "]. ", e);
        }
        return result;
    }

    public void addManagedDependency(Dependency manDep) {
        if (!this.hasEffectiveManagedDependency(this.resolveProperties(manDep))) {
            this.addDirectManagedDependency(manDep);
        }
    }

    public void addDirectManagedDependency(Dependency dep) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        DependencyManagement depMan = pom.getDependencyManagement();
        depMan = depMan != null ? depMan : new DependencyManagement();
        List managedDependencies = MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies());
        ListIterator<Dependency> managedDepsIterator = managedDependencies.listIterator();
        boolean found = false;
        while (managedDepsIterator.hasNext()) {
            Dependency managedDependency = (Dependency)managedDepsIterator.next();
            if (!Dependencies.areEquivalent((Dependency)managedDependency, (Dependency)dep)) continue;
            managedDepsIterator.set(dep);
            found = true;
        }
        if (!found) {
            managedDependencies.add(dep);
        }
        depMan.setDependencies(MavenDependencyAdapter.toMavenList((List)managedDependencies));
        pom.setDependencyManagement(depMan);
        maven.setModel(pom);
    }

    public boolean hasEffectiveManagedDependency(Dependency manDep) {
        return this.getEffectiveManagedDependency(this.resolveProperties(manDep)) != null;
    }

    public Dependency getEffectiveManagedDependency(Dependency manDep) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        try {
            DependencyManagement depMan = ((MavenFacetImpl)maven).getProjectBuildingResult().getProject().getDependencyManagement();
            List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
            for (Dependency managedDependency : managedDependencies) {
                if (!Dependencies.areEquivalent((Dependency)managedDependency, (Dependency)this.resolveProperties(manDep))) continue;
                return this.resolveProperties(managedDependency);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not resolve managed dependencies in project [" + maven.getModelResource().getFullyQualifiedName() + "]. ", e);
        }
        return null;
    }

    public boolean hasDirectManagedDependency(Dependency managedDependency) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        DependencyManagement depMan = pom.getDependencyManagement();
        List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        for (Dependency manDep : managedDependencies) {
            if (!Dependencies.areEquivalent((Dependency)this.resolveProperties(managedDependency), (Dependency)manDep)) continue;
            return true;
        }
        return false;
    }

    public void removeManagedDependency(Dependency manDep) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        DependencyManagement depMan = pom.getDependencyManagement();
        depMan = depMan != null ? depMan : new DependencyManagement();
        List managedDependencies = MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies());
        ArrayList<Dependency> toBeRemoved = new ArrayList<Dependency>();
        for (Dependency managedDependency : managedDependencies) {
            if (!Dependencies.areEquivalent((Dependency)managedDependency, (Dependency)manDep)) continue;
            toBeRemoved.add(managedDependency);
        }
        managedDependencies.removeAll(toBeRemoved);
        depMan.setDependencies(MavenDependencyAdapter.toMavenList((List)managedDependencies));
        pom.setDependencyManagement(depMan);
        maven.setModel(pom);
    }

    public List<Dependency> getManagedDependencies() {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        DependencyManagement depMan = pom.getDependencyManagement();
        ArrayList managedDependencies = null;
        managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : managedDependencies) {
            result.add(this.resolveProperties(dependency));
        }
        return result;
    }

    public Dependency getDirectManagedDependency(Dependency manDep) {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        DependencyManagement depMan = pom.getDependencyManagement();
        List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        for (Dependency managedDependency : managedDependencies) {
            if (!Dependencies.areEquivalent((Dependency)managedDependency, (Dependency)this.resolveProperties(manDep))) continue;
            return this.resolveProperties(managedDependency);
        }
        return null;
    }

    public Dependency resolveProperties(Dependency dependency) {
        MavenFacet mvn = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        DependencyBuilder builder = DependencyBuilder.create((Dependency)dependency);
        builder.setGroupId(mvn.resolveProperties(dependency.getCoordinate().getGroupId()));
        builder.setArtifactId(mvn.resolveProperties(dependency.getCoordinate().getArtifactId()));
        builder.setVersion(mvn.resolveProperties(dependency.getCoordinate().getVersion()));
        builder.setClassifier(mvn.resolveProperties(dependency.getCoordinate().getClassifier()));
        builder.setPackaging(mvn.resolveProperties(dependency.getCoordinate().getPackaging()));
        builder.setScopeType(mvn.resolveProperties(dependency.getScopeType()));
        return builder;
    }

    public List<Coordinate> resolveAvailableVersions(String gavs) {
        return this.resolveAvailableVersions((Dependency)DependencyBuilder.create((String)gavs));
    }

    public List<Coordinate> resolveAvailableVersions(Dependency dep) {
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Coordinate)dep.getCoordinate()).setRepositories(this.getRepositories());
        if (dep.getCoordinate().getVersion() != null && !dep.getCoordinate().getVersion().contains("SNAPSHOT")) {
            query.setFilter((Predicate)new NonSnapshotDependencyFilter());
        }
        List versions = this.resolver.resolveVersions((DependencyQuery)query);
        return versions;
    }

    public List<Coordinate> resolveAvailableVersions(DependencyQuery query) {
        List versions = this.resolver.resolveVersions(query);
        return versions;
    }

    public void addRepository(String name, String url) {
        if (!this.hasRepository(url)) {
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            Repository repo = new Repository();
            repo.setId(name);
            repo.setUrl(url);
            pom.getRepositories().add(repo);
            maven.setModel(pom);
        }
    }

    public List<DependencyRepository> getRepositories() {
        ArrayList<DependencyRepository> results = new ArrayList<DependencyRepository>();
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        List repos = pom.getRepositories();
        for (Repository repo : repos) {
            results.add(new DependencyRepository(repo.getId(), repo.getUrl()));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean hasRepository(String url) {
        if (url != null) {
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            List repositories = pom.getRepositories();
            for (Repository repo : repositories) {
                if (!repo.getUrl().trim().equals(url.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public DependencyRepository removeRepository(String url) {
        if (url != null) {
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            List repos = pom.getRepositories();
            for (Repository repo : repos) {
                if (!repo.getUrl().equals(url.trim())) continue;
                repos.remove(repo);
                maven.setModel(pom);
                return new DependencyRepository(repo.getId(), repo.getUrl());
            }
        }
        return null;
    }

    public List<Dependency> getDependenciesInScopes(String ... scopes) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        List<Dependency> dependencies = this.getDependencies();
        block0: for (Dependency dependency : dependencies) {
            for (String scope : scopes) {
                if (dependency.getScopeType() != null && !dependency.getScopeType().equals(scope)) continue;
                dependency = this.resolveProperties(dependency);
                result.add(dependency);
                continue block0;
            }
        }
        return result;
    }

    public List<Dependency> getEffectiveDependenciesInScopes(String ... scopes) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        List<Dependency> dependencies = this.getEffectiveDependencies();
        block0: for (Dependency dependency : dependencies) {
            for (String scope : scopes) {
                if (dependency.getScopeType() != null && !dependency.getScopeType().equals(scope)) continue;
                dependency = this.resolveProperties(dependency);
                result.add(dependency);
                continue block0;
            }
        }
        return result;
    }

    public void setFaceted(Project project) {
        super.setFaceted((Faceted)project);
    }
}

