/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.monitor;

import java.io.IOException;
import javax.enterprise.event.Observes;
import javax.inject.Singleton;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.monitor.FileWatcher;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.addon.resource.monitor.ResourceMonitorImpl;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;

@Singleton
public class FileMonitor {
    private FileWatcher watcher;

    void init(@Observes @Local PostStartup postStartup) throws Exception {
        this.watcher = new FileWatcher();
        this.watcher.start();
    }

    void destroy(@Observes @Local PreShutdown preShutdown) throws Exception {
        if (this.watcher != null) {
            this.watcher.stop();
            this.watcher = null;
        }
    }

    public ResourceMonitor registerMonitor(ResourceFactory resourceFactory, final FileResource<?> resource, final ResourceFilter resourceFilter) {
        if (this.watcher == null) {
            throw new IllegalStateException("File Monitor is not started yet");
        }
        DirectoryResource dirResource = (DirectoryResource)resource.reify(DirectoryResource.class);
        ResourceFilter filter = resourceFilter;
        if (dirResource == null) {
            dirResource = resource.getParent();
            filter = new ResourceFilter(){

                public boolean accept(Resource<?> type) {
                    boolean isMonitoredFile = type.equals((Object)resource);
                    if (!isMonitoredFile) {
                        return false;
                    }
                    if (resourceFilter != null) {
                        return resourceFilter.accept(type);
                    }
                    return true;
                }
            };
        }
        ResourceMonitorImpl resourceMonitor = new ResourceMonitorImpl(this, dirResource, resourceFactory, filter);
        try {
            this.watcher.register(resourceMonitor);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not register resource monitor", e);
        }
        return resourceMonitor;
    }

    void cancel(ResourceMonitorImpl monitor) {
        this.watcher.unregister(monitor);
    }
}

