/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.transaction.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.resource.FileOperations;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.events.ResourceCreated;
import org.jboss.forge.addon.resource.events.ResourceDeleted;
import org.jboss.forge.addon.resource.events.ResourceEvent;
import org.jboss.forge.addon.resource.events.ResourceModified;
import org.jboss.forge.addon.resource.transaction.ResourceTransaction;
import org.jboss.forge.addon.resource.transaction.ResourceTransactionException;
import org.jboss.forge.addon.resource.transaction.ResourceTransactionListener;
import org.jboss.forge.addon.resource.transaction.file.AvailableInputStreamWrapper;
import org.jboss.forge.addon.resource.transaction.file.FileResourceTransactionManager;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.xadisk.additional.XAFileInputStreamWrapper;
import org.xadisk.additional.XAFileOutputStreamWrapper;
import org.xadisk.bridge.proxies.interfaces.Session;
import org.xadisk.bridge.proxies.interfaces.XADiskBasicIOOperations;
import org.xadisk.bridge.proxies.interfaces.XAFileInputStream;
import org.xadisk.bridge.proxies.interfaces.XAFileOutputStream;
import org.xadisk.bridge.proxies.interfaces.XAFileSystem;
import org.xadisk.bridge.proxies.interfaces.XAFileSystemProxy;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.exceptions.DirectoryNotEmptyException;
import org.xadisk.filesystem.exceptions.FileAlreadyExistsException;
import org.xadisk.filesystem.exceptions.FileNotExistsException;
import org.xadisk.filesystem.exceptions.InsufficientPermissionOnFileException;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;
import org.xadisk.filesystem.standalone.StandaloneFileSystemConfiguration;

public class FileResourceTransactionImpl
implements ResourceTransaction,
FileOperations,
Closeable {
    private static final Logger log = Logger.getLogger(FileResourceTransactionImpl.class.getName());
    private final FileResourceTransactionManager manager;
    private final ResourceFactory resourceFactory;
    private XAFileSystem fileSystem;
    private volatile Session session;
    private volatile boolean started;
    private int timeout = 0;

    public FileResourceTransactionImpl(FileResourceTransactionManager manager, ResourceFactory resourceFactory) {
        this.manager = manager;
        this.resourceFactory = resourceFactory;
    }

    public void begin() throws ResourceTransactionException {
        this.session = this.getFileSystem().createSessionForLocalTransaction();
        this.started = true;
        if (this.timeout > 0) {
            this.session.setTransactionTimeout(this.timeout);
        }
        for (ResourceTransactionListener listener : this.manager.getTransactionListeners()) {
            try {
                listener.transactionStarted((ResourceTransaction)this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error encountered while notifying ResourceTransactionListener: [" + listener + "]", e);
            }
        }
    }

    public void commit() throws ResourceTransactionException {
        this.assertSessionCreated();
        try {
            this.started = false;
            Set<ResourceEvent> changeSet = this.getChangeSet();
            this.session.commit();
            for (ResourceTransactionListener listener : this.manager.getTransactionListeners()) {
                try {
                    listener.transactionCommitted((ResourceTransaction)this, changeSet);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error encountered while notifying ResourceTransactionListener: [" + listener + "]", e);
                }
            }
        }
        catch (NoTransactionAssociatedException e) {
            throw new ResourceTransactionException("No transaction is associated", (Throwable)e);
        }
        finally {
            this.session = null;
        }
    }

    public void rollback() throws ResourceTransactionException {
        this.assertSessionCreated();
        try {
            this.started = false;
            this.session.rollback();
            for (ResourceTransactionListener listener : this.manager.getTransactionListeners()) {
                try {
                    listener.transactionRolledBack((ResourceTransaction)this);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error encountered while notifying ResourceTransactionListener: [" + listener + "]", e);
                }
            }
        }
        catch (NoTransactionAssociatedException e) {
            throw new ResourceTransactionException("No transaction is associated", (Throwable)e);
        }
        finally {
            this.session = null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public Set<ResourceEvent> getChangeSet() {
        this.assertSessionCreated();
        LinkedHashSet<Object> changes = new LinkedHashSet<Object>();
        try {
            Field declaredField = NativeSession.class.getDeclaredField("fileStateChangeEventsToRaise");
            declaredField.setAccessible(true);
            List events = (List)declaredField.get(this.session);
            for (FileSystemStateChangeEvent changeEvent : events) {
                File file = changeEvent.getFile();
                Resource resource = this.resourceFactory.create((Object)file);
                switch (changeEvent.getEventType()) {
                    case CREATED: {
                        changes.add(new ResourceCreated(resource));
                        break;
                    }
                    case DELETED: {
                        changes.add(new ResourceDeleted(resource));
                        break;
                    }
                    case MODIFIED: {
                        changes.add(new ResourceModified(resource));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableSet(changes);
    }

    public boolean fileExists(File f) {
        this.assertSessionCreated();
        try {
            return this.session.fileExists(f);
        }
        catch (InsufficientPermissionOnFileException pe) {
            if (pe.getMissingPermission() == XADiskBasicIOOperations.PermissionType.READ_DIRECTORY && !pe.getPath().equals(f.getAbsolutePath())) {
                return false;
            }
            throw new ResourceTransactionException("Error while checking if file exists", (Throwable)pe);
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while checking if file exists", (Throwable)e);
        }
    }

    public boolean fileExistsAndIsDirectory(File f) {
        this.assertSessionCreated();
        try {
            return this.session.fileExistsAndIsDirectory(f);
        }
        catch (InsufficientPermissionOnFileException pe) {
            if (pe.getMissingPermission() == XADiskBasicIOOperations.PermissionType.READ_DIRECTORY && !pe.getPath().equals(f.getAbsolutePath())) {
                return false;
            }
            throw new ResourceTransactionException("Error while checking if file exists and is a directory", (Throwable)pe);
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while checking if file exists and is a directory", (Throwable)e);
        }
    }

    public File[] listFiles(File file) {
        this.assertSessionCreated();
        try {
            String[] fileList = this.session.listFiles(file);
            File[] files = new File[fileList.length];
            for (int i = 0; i < fileList.length; ++i) {
                files[i] = new File(file, fileList[i]);
            }
            return files;
        }
        catch (FileNotExistsException fne) {
            return new File[0];
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while listing files", (Throwable)e);
        }
    }

    public long getFileLength(File f) {
        this.assertSessionCreated();
        try {
            return this.session.getFileLength(f);
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while getting file length", (Throwable)e);
        }
    }

    public boolean renameFile(File src, File dest) {
        this.assertSessionCreated();
        try {
            this.session.moveFile(src, dest);
            return true;
        }
        catch (FileAlreadyExistsException fae) {
            return false;
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while renaming file from " + src + " to " + dest, (Throwable)e);
        }
    }

    public void copyFile(File src, File dest) throws IOException {
        this.assertSessionCreated();
        try {
            this.session.copyFile(src, dest);
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while copying file from " + src + " to " + dest, (Throwable)e);
        }
    }

    public boolean deleteFile(File f) {
        this.assertSessionCreated();
        try {
            this.session.deleteFile(f);
            return true;
        }
        catch (FileNotExistsException fne) {
            return false;
        }
        catch (DirectoryNotEmptyException dne) {
            return false;
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while deleting file " + f, (Throwable)e);
        }
    }

    public boolean createNewFile(File file) throws IOException {
        this.assertSessionCreated();
        try {
            this.session.createFile(file, false);
            return true;
        }
        catch (FileAlreadyExistsException fae) {
            return false;
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while creating new file in " + file, (Throwable)e);
        }
    }

    public boolean mkdir(File file) {
        this.assertSessionCreated();
        try {
            this.session.createFile(file, true);
            return true;
        }
        catch (FileAlreadyExistsException fae) {
            return false;
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while making directory " + file, (Throwable)e);
        }
    }

    public boolean mkdirs(File file) {
        this.assertSessionCreated();
        try {
            LinkedList<File> stack = new LinkedList<File>();
            for (File parent = file; parent != null && !this.fileExistsAndIsDirectory(parent); parent = parent.getParentFile()) {
                stack.push(parent);
            }
            while (!stack.isEmpty()) {
                this.session.createFile((File)stack.pop(), true);
            }
            return true;
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while making directories " + file, (Throwable)e);
        }
    }

    public OutputStream createOutputStream(File f) throws IOException {
        this.assertSessionCreated();
        try {
            this.session.truncateFile(f, 0L);
            XAFileOutputStream xaStream = this.session.createXAFileOutputStream(f, false);
            return new XAFileOutputStreamWrapper(xaStream);
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while creating output stream for " + f, (Throwable)e);
        }
    }

    public InputStream createInputStream(File f) throws IOException {
        this.assertSessionCreated();
        try {
            long fileLength = this.session.getFileLength(f);
            XAFileInputStream xaStream = this.session.createXAFileInputStream(f);
            XAFileInputStreamWrapper xaWrapper = new XAFileInputStreamWrapper(xaStream);
            return new AvailableInputStreamWrapper((InputStream)xaWrapper, (int)fileLength);
        }
        catch (Exception e) {
            throw new ResourceTransactionException("Error while creating input stream for " + f, (Throwable)e);
        }
    }

    public void setTransactionTimeout(int seconds) {
        if (seconds < 0) {
            throw new ResourceTransactionException("Timeout cannot be a negative value");
        }
        this.timeout = seconds;
    }

    public int getTransactionTimeout() {
        return this.session == null ? this.timeout : this.session.getTransactionTimeout();
    }

    public void deleteFileOnExit(File file) {
        file.deleteOnExit();
    }

    private void assertSessionCreated() {
        Assert.notNull((Object)this.session, (String)"Transaction is not started");
    }

    private XAFileSystem getFileSystem() {
        if (this.fileSystem == null) {
            File xaDiskHome = OperatingSystemUtils.createTempDir();
            StandaloneFileSystemConfiguration config = new StandaloneFileSystemConfiguration(xaDiskHome.getAbsolutePath(), "furnace-instance");
            config.setTransactionTimeout(Integer.valueOf(3600));
            if (OperatingSystemUtils.isWindows()) {
                config.setSynchronizeDirectoryChanges(Boolean.FALSE);
            }
            this.fileSystem = XAFileSystemProxy.bootNativeXAFileSystem((StandaloneFileSystemConfiguration)config);
            try {
                this.fileSystem.waitForBootup(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.fileSystem;
    }

    @Override
    public void close() throws IOException {
        if (this.session != null) {
            try {
                this.session.rollback();
            }
            catch (NoTransactionAssociatedException noTransactionAssociatedException) {
                // empty catch block
            }
        }
        if (this.fileSystem != null) {
            this.fileSystem.shutdown();
        }
    }
}

