/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonFilter;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.cdi.services.ExportedInstanceImpl;
import org.jboss.forge.furnace.container.cdi.services.LocalServiceInjectionPoint;
import org.jboss.forge.furnace.container.cdi.util.BeanManagerUtils;
import org.jboss.forge.furnace.container.cdi.util.ContextualLifecycle;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.AddonFilters;

class ImportedBeanLifecycle
implements ContextualLifecycle<Object> {
    private static final AddonFilter ALL_STARTED = AddonFilters.allStarted();
    private final Annotated annotated;
    private final Member member;
    private final InjectionPoint injectionPoint;
    private final BeanManager manager;

    ImportedBeanLifecycle(Annotated annotated, Member member, InjectionPoint injectionPoint, BeanManager manager) {
        this.annotated = annotated;
        this.member = member;
        this.injectionPoint = injectionPoint;
        this.manager = manager;
    }

    @Override
    public void destroy(Bean<Object> bean, Object instance, CreationalContext<Object> creationalContext) {
        creationalContext.release();
    }

    @Override
    public Object create(Bean<Object> bean, CreationalContext<Object> creationalContext) {
        ExportedInstance instance;
        Addon addon;
        ServiceRegistry serviceRegistry;
        Class<?> serviceType = null;
        if (this.member instanceof Method) {
            serviceType = this.annotated instanceof AnnotatedParameter ? ((Method)this.member).getParameterTypes()[((AnnotatedParameter)this.annotated).getPosition()] : ((Method)this.member).getReturnType();
        } else if (this.member instanceof Field) {
            serviceType = ((Field)this.member).getType();
        } else if (this.member instanceof Constructor) {
            if (this.annotated instanceof AnnotatedParameter) {
                serviceType = ((Constructor)this.member).getParameterTypes()[((AnnotatedParameter)this.annotated).getPosition()];
            }
        } else {
            throw new ContainerException("Cannot handle producer for non-Field and non-Method member type: " + this.member);
        }
        AddonRegistry registry = BeanManagerUtils.getContextualInstance(this.manager, AddonRegistry.class);
        Object result = null;
        Iterator i$ = registry.getAddons(ALL_STARTED).iterator();
        while (i$.hasNext() && (!(serviceRegistry = (addon = (Addon)i$.next()).getServiceRegistry()).hasService(serviceType) || (instance = serviceRegistry.getExportedInstance(serviceType)) == null || (result = instance instanceof ExportedInstanceImpl ? ((ExportedInstanceImpl)instance).get(new LocalServiceInjectionPoint(this.injectionPoint, serviceType)) : instance.get()) == null)) {
        }
        if (result == null) {
            throw new IllegalStateException("Addon service [" + serviceType.getName() + "] is not registered.");
        }
        return result;
    }
}

