/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.services;

import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.cdi.impl.WeldServiceRegistry;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.proxy.ClassLoaderInterceptor;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.ClassLoaders;

public class ExportedInstanceImpl<R>
implements ExportedInstance<R> {
    private final Addon addon;
    private final BeanManager manager;
    private CreationalContext<R> context;
    private final Bean<R> requestedBean;
    private final Class<R> requestedType;
    private final Class<? extends R> actualType;

    public ExportedInstanceImpl(Addon addon, BeanManager manager, Bean<R> requestedBean, Class<R> requestedType, Class<? extends R> actualType) {
        Assert.notNull((Object)addon, (String)"Source addon must not be null.");
        Assert.notNull((Object)manager, (String)"Bean manager must not be null.");
        Assert.notNull(requestedBean, (String)"Requested bean must not be null.");
        Assert.notNull(requestedType, (String)"Requested type must not be null.");
        Assert.notNull(actualType, (String)"Actual type must not be null.");
        this.addon = addon;
        this.manager = manager;
        this.requestedBean = requestedBean;
        this.requestedType = requestedType;
        this.actualType = actualType;
    }

    public R get() {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ExportedInstanceImpl.this.context = ExportedInstanceImpl.this.manager.createCreationalContext((Contextual)ExportedInstanceImpl.this.requestedBean);
                Object delegate = ExportedInstanceImpl.this.manager.getReference(ExportedInstanceImpl.this.requestedBean, (Type)ExportedInstanceImpl.this.actualType, ExportedInstanceImpl.this.context);
                return Proxies.enhance((ClassLoader)ExportedInstanceImpl.this.addon.getClassLoader(), (Object)delegate, (ForgeProxy)new ClassLoaderInterceptor(ExportedInstanceImpl.this.addon.getClassLoader(), delegate));
            }
        };
        try {
            return (R)ClassLoaders.executeIn((ClassLoader)this.addon.getClassLoader(), (Callable)task);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to get instance of [" + this.actualType + "] with proxy for ClassLoader [" + this.addon.getClassLoader() + "]", (Throwable)e);
        }
    }

    public Class<? extends R> getActualType() {
        return this.actualType;
    }

    public Addon getSourceAddon() {
        return this.addon;
    }

    public Object get(final InjectionPoint injectionPoint) {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Bean bean = ExportedInstanceImpl.this.manager.resolve(ExportedInstanceImpl.this.manager.getBeans((Type)ExportedInstanceImpl.this.actualType, WeldServiceRegistry.getQualifiersFrom(ExportedInstanceImpl.this.actualType)));
                ExportedInstanceImpl.this.context = ExportedInstanceImpl.this.manager.createCreationalContext((Contextual)bean);
                Object delegate = ExportedInstanceImpl.this.manager.getInjectableReference(injectionPoint, ExportedInstanceImpl.this.context);
                return Proxies.enhance((ClassLoader)ExportedInstanceImpl.this.addon.getClassLoader(), (Object)delegate, (ForgeProxy)new ClassLoaderInterceptor(ExportedInstanceImpl.this.addon.getClassLoader(), delegate));
            }
        };
        try {
            return ClassLoaders.executeIn((ClassLoader)this.addon.getClassLoader(), (Callable)task);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to get instance of [" + this.actualType + "] from addon [" + this.addon + "]", (Throwable)e);
        }
    }

    public void release(R instance) {
        this.context.release();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExportedInstanceImpl [");
        if (this.requestedType != null) {
            builder.append("requestedType=").append(this.requestedType).append(", ");
        }
        if (this.actualType != null) {
            builder.append("actualType=").append(this.actualType).append(", ");
        }
        if (this.addon.getClassLoader() != null) {
            builder.append("addon.getClassLoader()=").append(this.addon.getClassLoader());
        }
        builder.append("]");
        return builder.toString();
    }
}

