/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.input;

import java.util.Set;
import java.util.concurrent.Callable;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.ui.impl.input.AbstractInputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Callables;
import org.jboss.forge.furnace.util.Strings;

@Vetoed
public class UIInputImpl<VALUETYPE>
extends AbstractInputComponent<UIInput<VALUETYPE>, VALUETYPE>
implements UIInput<VALUETYPE> {
    private VALUETYPE value;
    private Callable<VALUETYPE> defaultValue;
    private UICompleter<VALUETYPE> completer;
    private Converter<String, VALUETYPE> converter;

    public UIInputImpl(String name, char shortName, Class<VALUETYPE> type) {
        super(name, shortName, type);
    }

    public UICompleter<VALUETYPE> getCompleter() {
        return this.completer;
    }

    public UIInput<VALUETYPE> setCompleter(UICompleter<VALUETYPE> completer) {
        this.completer = completer;
        return this;
    }

    public UIInput<VALUETYPE> setValue(VALUETYPE value) {
        Set<ValueChangeListener> listeners = this.getValueChangeListeners();
        if (!listeners.isEmpty() && !InputComponents.areEqual(this.getValue(), value)) {
            this.fireValueChangeListeners(value);
        }
        this.value = value;
        return this;
    }

    public UIInput<VALUETYPE> setDefaultValue(Callable<VALUETYPE> callback) {
        this.defaultValue = callback;
        return this;
    }

    public UIInput<VALUETYPE> setDefaultValue(VALUETYPE value) {
        this.defaultValue = Callables.returning(value);
        return this;
    }

    public VALUETYPE getValue() {
        return (VALUETYPE)(this.value == null ? Callables.call(this.defaultValue) : this.value);
    }

    @Override
    public Converter<String, VALUETYPE> getValueConverter() {
        return this.converter;
    }

    @Override
    public UIInput<VALUETYPE> setValueConverter(Converter<String, VALUETYPE> converter) {
        this.converter = converter;
        return this;
    }

    public String toString() {
        return "UIInputImpl [name=" + this.getName() + ", shortName='" + this.getShortName() + "', value=" + this.value + ", defaultValue=" + this.defaultValue + "]";
    }

    public boolean hasDefaultValue() {
        Object defaultValueValue = Callables.call(this.defaultValue);
        if (defaultValueValue instanceof String) {
            return !Strings.isNullOrEmpty((String)((String)defaultValueValue));
        }
        return defaultValueValue != null;
    }

    public boolean hasValue() {
        if (this.value instanceof String) {
            return !Strings.isNullOrEmpty((String)((String)this.value));
        }
        return this.value != null;
    }
}

