/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.input;

import java.util.Set;
import java.util.concurrent.Callable;
import org.jboss.forge.addon.ui.impl.input.AbstractUISelectInputComponent;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Callables;
import org.jboss.forge.furnace.util.Strings;

public class UISelectOneImpl<VALUETYPE>
extends AbstractUISelectInputComponent<UISelectOne<VALUETYPE>, VALUETYPE>
implements UISelectOne<VALUETYPE> {
    private VALUETYPE value;
    private Callable<VALUETYPE> defaultValue;

    public UISelectOneImpl(String name, char shortName, Class<VALUETYPE> type) {
        super(name, shortName, type);
    }

    public UISelectOne<VALUETYPE> setValue(VALUETYPE value) {
        Set<ValueChangeListener> listeners = this.getValueChangeListeners();
        if (!listeners.isEmpty() && !InputComponents.areEqual(this.getValue(), value)) {
            this.fireValueChangeListeners(value);
        }
        this.value = value;
        return this;
    }

    public UISelectOne<VALUETYPE> setDefaultValue(Callable<VALUETYPE> callback) {
        this.defaultValue = callback;
        return this;
    }

    public UISelectOne<VALUETYPE> setDefaultValue(VALUETYPE value) {
        this.defaultValue = Callables.returning(value);
        return this;
    }

    public VALUETYPE getValue() {
        return (VALUETYPE)(this.value == null ? Callables.call(this.defaultValue) : this.value);
    }

    public boolean hasDefaultValue() {
        Object defaultValueValue = Callables.call(this.defaultValue);
        if (defaultValueValue instanceof String) {
            return !Strings.isNullOrEmpty((String)((String)defaultValueValue));
        }
        return defaultValueValue != null;
    }

    public boolean hasValue() {
        if (this.value instanceof String) {
            return !Strings.isNullOrEmpty((String)((String)this.value));
        }
        return this.value != null;
    }

    public String toString() {
        return "UISelectOneImpl [name=" + this.getName() + ", shortName='" + this.getShortName() + "', value=" + this.value + ", defaultValue=" + this.defaultValue + "]";
    }
}

