/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.impl.EnumConstantBodyImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.util.Strings;

public class EnumConstantImpl
implements EnumConstantSource {
    private final AnnotationAccessor<JavaEnumSource, EnumConstantSource> annotations = new AnnotationAccessor();
    private JavaEnumSource parent;
    private AST ast;
    private EnumConstantDeclaration enumConstant;

    private void init(JavaEnumSource parent) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
    }

    public EnumConstantImpl(JavaEnumSource parent) {
        this.init(parent);
        this.enumConstant = this.ast.newEnumConstantDeclaration();
    }

    public EnumConstantImpl(JavaEnumSource parent, String declaration) {
        EnumConstantDeclaration subtree;
        this.init(parent);
        String stub = "public enum Stub { " + declaration + " }";
        JavaEnumSource temp = (JavaEnumSource)Roaster.parse((String)stub);
        List constants = temp.getEnumConstants();
        EnumConstantDeclaration newField = (EnumConstantDeclaration)((EnumConstantSource)constants.get(0)).getInternal();
        this.enumConstant = subtree = (EnumConstantDeclaration)ASTNode.copySubtree(this.ast, newField);
    }

    public EnumConstantImpl(JavaEnumSource parent, Object internal) {
        this.init(parent);
        this.enumConstant = (EnumConstantDeclaration)internal;
    }

    public String getName() {
        return this.enumConstant.getName().getFullyQualifiedName();
    }

    public EnumConstantSource setName(String name) {
        this.enumConstant.setName(this.ast.newSimpleName(name));
        return this;
    }

    public Object getInternal() {
        return this.enumConstant;
    }

    public JavaEnumSource getOrigin() {
        return this.parent;
    }

    public List<String> getConstructorArguments() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : this.enumConstant.arguments()) {
            result.add(o.toString());
        }
        return Collections.unmodifiableList(result);
    }

    public EnumConstantSource setConstructorArguments(String ... literalArguments) {
        this.enumConstant.arguments().clear();
        if (literalArguments != null && literalArguments.length > 0) {
            String stub = "public enum Stub { FOO(" + Strings.join(Arrays.asList(literalArguments), (String)", ") + "); }";
            JavaEnumSource temp = (JavaEnumSource)Roaster.parse(JavaEnumSource.class, (String)stub);
            List constants = temp.getEnumConstants();
            EnumConstantDeclaration newConstant = (EnumConstantDeclaration)((EnumConstantSource)constants.get(0)).getInternal();
            List arguments = newConstant.arguments();
            for (Expression argument : arguments) {
                Expression subtree = (Expression)ASTNode.copySubtree(this.ast, argument);
                this.enumConstant.arguments().add(subtree);
            }
        }
        return this;
    }

    public EnumConstantSource.Body getBody() {
        return new EnumConstantBodyImpl(this);
    }

    public EnumConstantSource removeBody() {
        this.enumConstant.setAnonymousClassDeclaration(null);
        return this;
    }

    public AnnotationSource<JavaEnumSource> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaEnumSource, EnumConstantSource>)this, this.enumConstant);
    }

    public AnnotationSource<JavaEnumSource> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (!this.parent.hasImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaEnumSource, EnumConstantSource>)this, (ASTNode)this.enumConstant, clazz.getSimpleName());
    }

    public AnnotationSource<JavaEnumSource> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaEnumSource, EnumConstantSource>)this, (ASTNode)this.enumConstant, className);
    }

    public List<AnnotationSource<JavaEnumSource>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<JavaEnumSource, EnumConstantSource>)this, this.enumConstant);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.enumConstant, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.enumConstant, type);
    }

    public EnumConstantSource removeAnnotation(Annotation<JavaEnumSource> annotation) {
        return this.annotations.removeAnnotation(this, this.enumConstant, annotation);
    }

    public AnnotationSource<JavaEnumSource> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaEnumSource, EnumConstantSource>)this, (ASTNode)this.enumConstant, type);
    }

    public AnnotationSource<JavaEnumSource> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaEnumSource, EnumConstantSource>)this, (ASTNode)this.enumConstant, type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        EnumConstantImpl other = (EnumConstantImpl)obj;
        return other.enumConstant == this.enumConstant || other.enumConstant != null && other.enumConstant.equals(this.enumConstant);
    }

    public int hashCode() {
        int result = 912;
        return result | (this.enumConstant == null ? 0 : this.enumConstant.hashCode());
    }

    public String toString() {
        return this.enumConstant.toString();
    }
}

