/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaCore;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ToolFactory;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.formatter.CodeFormatter;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.BadLocationException;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster._shade.org.eclipse.text.edits.TextEdit;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.spi.Streams;

public abstract class Formatter {
    public static void format(File source) throws IOException {
        Formatter.format(null, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void format(File prefs, File source) throws IOException {
        Properties options = Formatter.readConfig(prefs);
        if (options == null) {
            options = Formatter.readConfigInternal("org.eclipse.jdt.core.prefs");
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(source));
            String content = Streams.toString(in);
            String formatted = Formatter.format(options, content);
            out = new BufferedOutputStream(new FileOutputStream(source));
            Streams.write(new ByteArrayInputStream(formatted.getBytes()), out);
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(in);
            Streams.closeQuietly(out);
            throw throwable;
        }
        Streams.closeQuietly(in);
        Streams.closeQuietly(out);
    }

    public static String format(JavaClassSource javaClass) {
        return Formatter.format(javaClass.toString());
    }

    public static String format(Properties prefs, JavaClassSource javaClass) {
        return Formatter.format(prefs, javaClass.toString());
    }

    public static String format(String source) {
        Properties options = Formatter.readConfigInternal("org.eclipse.jdt.core.prefs");
        return Formatter.format(options, source);
    }

    public static String format(Properties prefs, String source) {
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(prefs);
        return Formatter._format(source, codeFormatter);
    }

    private static String _format(String contents, CodeFormatter codeFormatter) {
        Document doc = new Document(contents);
        try {
            TextEdit edit = codeFormatter.format(8, contents, 0, contents.length(), 0, null);
            if (edit == null) {
                return contents;
            }
            edit.apply(doc);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        return Formatter.ensureCorrectNewLines(doc.get());
    }

    private static Properties readConfig(File prefs) throws IOException {
        if (prefs != null) {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(prefs));
            try {
                Properties config = Formatter.parseConfig(stream);
                Properties modified = new Properties();
                for (Map.Entry<Object, Object> property : config.entrySet()) {
                    String shadePackage = JavaCore.class.getPackage().getName().replaceAll("org\\.eclipse.*$", "");
                    modified.put(shadePackage + property.getKey(), property.getValue());
                }
                Properties properties = modified;
                return properties;
            }
            catch (IOException e) {
                throw new IOException("Error reading preferences file: [" + prefs.getAbsolutePath() + "]", e);
            }
            finally {
                Streams.closeQuietly(stream);
            }
        }
        return null;
    }

    private static Properties readConfigInternal(String filename) {
        BufferedInputStream stream = new BufferedInputStream(Formatter.class.getResourceAsStream(filename));
        try {
            Properties properties = Formatter.parseConfig(stream);
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading internal configuration: [" + filename + "]", e);
        }
        finally {
            Streams.closeQuietly(stream);
        }
    }

    private static Properties parseConfig(InputStream stream) throws IOException {
        try {
            Properties formatterOptions = new Properties();
            formatterOptions.load(stream);
            Properties properties = formatterOptions;
            return properties;
        }
        finally {
            Streams.closeQuietly(stream);
        }
    }

    private static String ensureCorrectNewLines(String content) {
        String newLine = System.getProperty("line.separator");
        if (content.indexOf("\n") != -1 && content.indexOf(newLine) == -1) {
            return content.replaceAll("\n", newLine);
        }
        return content;
    }
}

