/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.oupls.sail;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.oupls.sail.GraphSail;
import com.tinkerpop.blueprints.oupls.sail.IndexingMatcher;
import com.tinkerpop.blueprints.oupls.sail.Matcher;
import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.fortytwo.sesametools.CompoundCloseableIteration;
import net.fortytwo.sesametools.SailConnectionTripleSource;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.helpers.NotifyingSailConnectionBase;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.inferencer.InferencerConnection;

public class GraphSailConnection
extends NotifyingSailConnectionBase
implements InferencerConnection {
    private static final Resource[] NULL_CONTEXT_ARRAY = new Resource[]{null};
    private final GraphSail.DataStore store;
    private final Collection<WriteAction> writeBuffer = new LinkedList<WriteAction>();
    private boolean statementsAdded;
    private boolean statementsRemoved;
    private int writeSemaphore = 0;

    public GraphSailConnection(GraphSail.DataStore store) {
        super((SailBase)store.sail);
        this.store = store;
    }

    protected void startTransactionInternal() throws SailException {
        this.statementsAdded = false;
        this.statementsRemoved = false;
    }

    public void commitInternal() throws SailException {
        if (this.store.manualTransactions) {
            ((TransactionalGraph)this.store.graph).commit();
        }
        if (this.statementsAdded || this.statementsRemoved) {
            DefaultSailChangedEvent e = new DefaultSailChangedEvent((Sail)this.store.sail);
            e.setStatementsAdded(this.statementsAdded);
            e.setStatementsRemoved(this.statementsRemoved);
            this.store.sail.notifySailChanged((SailChangedEvent)e);
        }
    }

    public void rollbackInternal() throws SailException {
        if (this.store.manualTransactions) {
            ((TransactionalGraph)this.store.graph).stopTransaction(TransactionalGraph.Conclusion.FAILURE);
        }
    }

    public void closeInternal() throws SailException {
        if (this.store.manualTransactions) {
            ((TransactionalGraph)this.store.graph).stopTransaction(TransactionalGraph.Conclusion.FAILURE);
        }
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        try {
            SailConnectionTripleSource tripleSource = new SailConnectionTripleSource((SailConnection)this, this.store.valueFactory, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            return strategy.evaluate(tupleExpr, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        throw new UnsupportedOperationException("the getContextIDs operation is not yet supported");
    }

    public CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subject, URI predicate, Value object, boolean includeInferred, Resource ... contexts) throws SailException {
        int index = 0;
        if (null != subject) {
            index |= 1;
        }
        if (null != predicate) {
            index |= 2;
        }
        if (null != object) {
            index |= 4;
        }
        if (0 == contexts.length) {
            return this.createIteration(this.store.matchers[index].match(subject, predicate, object, null, includeInferred));
        }
        LinkedList<CloseableIteration<Statement, SailException>> iterations = new LinkedList<CloseableIteration<Statement, SailException>>();
        for (Resource context : contexts) {
            Matcher m = this.store.matchers[index |= 8];
            iterations.add(this.createIteration(m.match(subject, predicate, object, context, includeInferred)));
        }
        return new CompoundCloseableIteration(iterations);
    }

    public long sizeInternal(Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            return this.countIterator(this.store.matchers[0].match(null, null, null, null, false));
        }
        int count = 0;
        for (Resource context : contexts) {
            count += this.countIterator(this.store.matchers[8].match(null, null, null, context, false));
        }
        return count;
    }

    private int countIterator(Iterable i) {
        Iterator iter = i.iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    public void addStatementInternal(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        this.addStatementInternal(false, subject, predicate, object, contexts);
    }

    private void addStatementInternal(boolean inferred, Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        if (!this.canWrite()) {
            WriteAction a = new WriteAction(ActionType.ADD);
            a.inferred = inferred;
            a.subject = subject;
            a.predicate = predicate;
            a.object = object;
            a.contexts = contexts;
            this.queueUpdate(a);
            return;
        }
        if (null == subject || null == predicate || null == object) {
            throw new IllegalArgumentException("null part-of-speech for to-be-added statement");
        }
        if (this.store.uniqueStatements) {
            if (0 == contexts.length) {
                this.removeStatementsInternal(inferred, subject, predicate, object, new Resource[]{null});
                if (!inferred) {
                    this.removeStatementsInternal(true, subject, predicate, object, new Resource[]{null});
                }
            } else {
                this.removeStatementsInternal(inferred, subject, predicate, object, contexts);
                if (!inferred) {
                    this.removeStatementsInternal(true, subject, predicate, object, contexts);
                }
            }
        }
        for (Resource context : 0 == contexts.length ? NULL_CONTEXT_ARRAY : contexts) {
            String c = null == context ? "N" : this.store.resourceToNative(context);
            Vertex out = this.getOrCreateVertex((Value)subject);
            Vertex in = this.getOrCreateVertex(object);
            Edge edge = this.store.graph.addEdge(null, out, in, predicate.stringValue());
            if (inferred) {
                edge.setProperty("inferred", (Object)true);
            }
            for (IndexingMatcher m : this.store.indexers) {
                m.indexStatement(edge, subject, predicate, object, c);
            }
            if (null == edge.getProperty("c")) {
                edge.setProperty("c", (Object)this.store.valueToNative((Value)context));
            }
            if (!this.hasConnectionListeners()) continue;
            Statement s = this.store.valueFactory.createStatement(subject, predicate, object, context);
            this.notifyStatementAdded(s);
        }
        this.statementsAdded = true;
    }

    private Vertex getOrCreateVertex(Value value) {
        Vertex v = this.store.findVertex(value);
        if (null == v) {
            v = this.store.addVertex(value);
        }
        return v;
    }

    public void removeStatementsInternal(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        this.removeStatementsInternal(false, subject, predicate, object, contexts);
    }

    private void removeStatementsInternal(boolean inferred, Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        if (!this.canWrite()) {
            WriteAction a = new WriteAction(ActionType.REMOVE);
            a.inferred = inferred;
            a.subject = subject;
            a.predicate = predicate;
            a.object = object;
            a.contexts = contexts;
            this.queueUpdate(a);
            return;
        }
        LinkedList<Edge> edgesToRemove = new LinkedList<Edge>();
        int index = 0;
        if (null != subject) {
            index |= 1;
        }
        if (null != predicate) {
            index |= 2;
        }
        if (null != object) {
            index |= 4;
        }
        if (0 == contexts.length) {
            Iterable<Edge> i = this.store.matchers[index].match(subject, predicate, object, null, inferred);
            for (Edge anI : i) {
                edgesToRemove.add(anI);
            }
        } else {
            for (Resource context : contexts) {
                Iterable<Edge> i = this.store.matchers[index |= 8].match(subject, predicate, object, context, inferred);
                for (Edge e : i) {
                    Boolean b = (Boolean)e.getProperty("inferred");
                    if ((inferred || null != b) && (!inferred || null == b || !b.booleanValue())) continue;
                    edgesToRemove.add(e);
                }
            }
        }
        for (Edge e : edgesToRemove) {
            SimpleStatement s;
            if (this.hasConnectionListeners()) {
                s = new SimpleStatement();
                this.fillStatement(s, e);
            } else {
                s = null;
            }
            this.removeEdge(e);
            if (null == s) continue;
            this.notifyStatementRemoved(s);
        }
        if (0 < edgesToRemove.size()) {
            this.statementsRemoved = true;
        }
    }

    public void clearInternal(Resource ... contexts) throws SailException {
        this.clearInternal(false, contexts);
    }

    private void clearInternal(boolean inferred, Resource ... contexts) throws SailException {
        if (!this.canWrite()) {
            WriteAction a = new WriteAction(ActionType.CLEAR);
            a.inferred = inferred;
            a.contexts = contexts;
            this.queueUpdate(a);
            return;
        }
        if (0 == contexts.length) {
            this.deleteEdgesInIterator(inferred, this.store.matchers[0].match(null, null, null, null, inferred));
        } else {
            for (Resource context : contexts) {
                this.deleteEdgesInIterator(inferred, this.store.matchers[8].match(null, null, null, context, inferred));
            }
        }
    }

    private void deleteEdgesInIterator(boolean inferred, Iterable<Edge> i) {
        Iterator<Edge> iter = i.iterator();
        while (iter.hasNext()) {
            SimpleStatement s;
            Edge e = iter.next();
            Boolean b = (Boolean)e.getProperty("inferred");
            if ((inferred || null != b) && (!inferred || null == b || !b.booleanValue())) continue;
            if (this.hasConnectionListeners()) {
                s = new SimpleStatement();
                this.fillStatement(s, e);
            } else {
                s = null;
            }
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException x) {
                // empty catch block
            }
            this.removeEdge(e);
            if (null != s) {
                this.notifyStatementRemoved(s);
            }
            this.statementsRemoved = true;
        }
    }

    private void removeEdge(Edge edge) {
        Vertex h = edge.getVertex(Direction.IN);
        Vertex t = edge.getVertex(Direction.OUT);
        this.store.graph.removeEdge(edge);
        if (!h.getEdges(Direction.IN, new String[0]).iterator().hasNext() && !h.getEdges(Direction.OUT, new String[0]).iterator().hasNext()) {
            try {
                this.store.graph.removeVertex(h);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
        if (!t.getEdges(Direction.OUT, new String[0]).iterator().hasNext() && !t.getEdges(Direction.IN, new String[0]).iterator().hasNext()) {
            try {
                this.store.graph.removeVertex(t);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
    }

    public CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        final Iterator prefixes = this.store.namespaces.getPropertyKeys().iterator();
        return new CloseableIteration<Namespace, SailException>(){

            public void close() throws SailException {
            }

            public boolean hasNext() throws SailException {
                return prefixes.hasNext();
            }

            public Namespace next() throws SailException {
                String prefix = (String)prefixes.next();
                String uri = (String)((GraphSailConnection)GraphSailConnection.this).store.namespaces.getProperty(prefix);
                return new NamespaceImpl(GraphSailConnection.this.fromNativePrefixKey(prefix), uri);
            }

            public void remove() throws SailException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getNamespaceInternal(String prefix) throws SailException {
        return (String)this.store.namespaces.getProperty(this.toNativePrefixKey(prefix));
    }

    public void setNamespaceInternal(String prefix, String uri) throws SailException {
        this.store.namespaces.setProperty(this.toNativePrefixKey(prefix), (Object)uri);
    }

    public void removeNamespaceInternal(String prefix) throws SailException {
        this.store.namespaces.removeProperty(this.toNativePrefixKey(prefix));
    }

    public void clearNamespacesInternal() throws SailException {
        throw new UnsupportedOperationException("the clearNamespaces operation is not yet supported");
    }

    private boolean canWrite() {
        return 0 == this.writeSemaphore;
    }

    private void writeSemaphoreUp() {
        ++this.writeSemaphore;
    }

    private void writeSemaphoreDown() throws SailException {
        --this.writeSemaphore;
        if (0 == this.writeSemaphore) {
            this.flushWrites();
        }
    }

    private void queueUpdate(WriteAction a) throws SailException {
        if (0 == this.writeSemaphore) {
            a.execute();
        } else {
            this.writeBuffer.add(a);
        }
    }

    private void flushWrites() throws SailException {
        for (WriteAction a : this.writeBuffer) {
            switch (a.type) {
                case ADD: {
                    this.addStatementInternal(true, a.subject, a.predicate, a.object, a.contexts);
                    break;
                }
                case REMOVE: {
                    this.removeStatementsInternal(true, a.subject, a.predicate, a.object, a.contexts);
                    break;
                }
                case CLEAR: {
                    this.clearInternal(true, a.contexts);
                }
            }
        }
        this.writeBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInferredStatement(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        for (Resource context : 0 == contexts.length ? NULL_CONTEXT_ARRAY : contexts) {
            boolean doAdd = true;
            if (this.store.uniqueStatements) {
                CloseableIteration<? extends Statement, SailException> i = this.getStatementsInternal(subject, predicate, object, true, context);
                try {
                    if (i.hasNext()) {
                        doAdd = false;
                    }
                }
                finally {
                    i.close();
                }
            }
            if (!doAdd) continue;
            this.addStatementInternal(true, subject, predicate, object, context);
        }
        return false;
    }

    public boolean removeInferredStatement(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        this.removeStatementsInternal(true, subject, predicate, object, contexts);
        return false;
    }

    public void clearInferred(Resource ... contexts) throws SailException {
        this.clearInternal(true, contexts);
    }

    public void flushUpdates() throws SailException {
    }

    private CloseableIteration<Statement, SailException> createIteration(Iterable<Edge> iterator) {
        return this.store.volatileStatements ? new VolatileStatementIteration(iterator) : new StableStatementIteration(iterator);
    }

    private void fillStatement(SimpleStatement s, Edge e) {
        s.subject = (Resource)this.toSesame(e.getVertex(Direction.OUT));
        s.predicate = this.store.valueFactory.createURI(e.getLabel());
        s.object = this.toSesame(e.getVertex(Direction.IN));
        s.context = (Resource)this.toSesame((String)e.getProperty("c"));
    }

    private String toNativePrefixKey(String prefix) {
        return 0 == prefix.length() ? "default-namespace" : prefix;
    }

    private String fromNativePrefixKey(String prefix) {
        return prefix.equals("default-namespace") ? "" : prefix;
    }

    private Value toSesame(Vertex v) {
        String value = (String)v.getProperty("value");
        String kind = (String)v.getProperty("kind");
        if (kind.equals("uri")) {
            return this.store.valueFactory.createURI(value);
        }
        if (kind.equals("literal")) {
            String datatype = (String)v.getProperty("type");
            String lang = (String)v.getProperty("lang");
            return null != datatype ? this.store.valueFactory.createLiteral(value, this.store.valueFactory.createURI(datatype)) : (null != lang ? this.store.valueFactory.createLiteral(value, lang) : this.store.valueFactory.createLiteral(value));
        }
        if (kind.equals("bnode")) {
            return this.store.valueFactory.createBNode(value);
        }
        throw new IllegalStateException("unexpected resource kind: " + kind);
    }

    private Value toSesame(String s) {
        switch (s.charAt(0)) {
            case 'U': {
                return this.store.valueFactory.createURI(s.substring(2));
            }
            case 'B': {
                return this.store.valueFactory.createBNode(s.substring(2));
            }
            case 'P': {
                return this.store.valueFactory.createLiteral(s.substring(2));
            }
            case 'T': {
                int i = s.indexOf(" ", 2);
                return this.store.valueFactory.createLiteral(s.substring(i + 1), this.store.valueFactory.createURI(s.substring(2, i)));
            }
            case 'L': {
                int i = s.indexOf(" ", 2);
                return this.store.valueFactory.createLiteral(s.substring(i + 1), s.substring(2, i));
            }
            case 'N': {
                return null;
            }
        }
        throw new IllegalStateException();
    }

    private class SimpleStatement
    implements Statement {
        private Resource subject;
        private URI predicate;
        private Value object;
        private Resource context;

        private SimpleStatement() {
        }

        public Resource getSubject() {
            return this.subject;
        }

        public URI getPredicate() {
            return this.predicate;
        }

        public Value getObject() {
            return this.object;
        }

        public Resource getContext() {
            return this.context;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(this.subject).append(", ").append(this.predicate).append(", ").append(this.object);
            if (null != this.context) {
                sb.append(", ").append(this.context);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    private class VolatileStatementIteration
    implements CloseableIteration<Statement, SailException> {
        private final SimpleStatement s;
        private final Iterator<Edge> iter;

        public VolatileStatementIteration(Iterable<Edge> iterator) {
            this.s = new SimpleStatement();
            this.iter = iterator.iterator();
        }

        public void close() throws SailException {
        }

        public boolean hasNext() throws SailException {
            return this.iter.hasNext();
        }

        public Statement next() throws SailException {
            Edge e = this.iter.next();
            GraphSailConnection.this.fillStatement(this.s, e);
            return this.s;
        }

        public void remove() throws SailException {
            throw new UnsupportedOperationException();
        }
    }

    private class StableStatementIteration
    implements CloseableIteration<Statement, SailException> {
        private final Iterator<Edge> iter;
        private boolean closed = false;

        public StableStatementIteration(Iterable<Edge> iterator) {
            GraphSailConnection.this.writeSemaphoreUp();
            this.iter = iterator.iterator();
        }

        public void close() throws SailException {
            if (!this.closed) {
                this.closed = true;
                GraphSailConnection.this.writeSemaphoreDown();
            }
        }

        public boolean hasNext() throws SailException {
            return !this.closed && this.iter.hasNext();
        }

        public Statement next() throws SailException {
            if (this.closed) {
                throw new IllegalStateException("already closed");
            }
            Edge e = this.iter.next();
            SimpleStatement s = new SimpleStatement();
            GraphSailConnection.this.fillStatement(s, e);
            return s;
        }

        public void remove() throws SailException {
            throw new UnsupportedOperationException();
        }
    }

    private class WriteAction {
        public final ActionType type;
        public Resource subject;
        public URI predicate;
        public Value object;
        public Resource[] contexts;
        public boolean inferred = true;

        public WriteAction(ActionType type) {
            this.type = type;
        }

        public void execute() throws SailException {
            switch (this.type) {
                case ADD: {
                    GraphSailConnection.this.addStatementInternal(this.inferred, this.subject, this.predicate, this.object, this.contexts);
                    break;
                }
                case REMOVE: {
                    GraphSailConnection.this.removeStatementsInternal(this.inferred, this.subject, this.predicate, this.object, this.contexts);
                    break;
                }
                case CLEAR: {
                    GraphSailConnection.this.clearInternal(this.inferred, this.contexts);
                }
            }
        }
    }

    private static enum ActionType {
        ADD,
        REMOVE,
        CLEAR;

    }
}

