/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core.InvalidReferenceException;
import freemarker.core.MessageUtil;
import freemarker.core.NonDateException;
import freemarker.core._DelayedJQuote;
import freemarker.core._ErrorDescriptionBuilder;
import freemarker.core._MiscTemplateException;
import freemarker.core._TemplateModelException;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.DateUtil;
import freemarker.template.utility.UnrecognizedTimeZoneException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

class DateBuiltins {
    static /* synthetic */ Class class$java$util$TimeZone;

    private DateBuiltins() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class iso_BI
    extends AbstractISOBI {
        iso_BI(boolean showOffset, int accuracy) {
            super(showOffset, accuracy);
        }

        protected TemplateModel calculateResult(Date date, int dateType, Environment env) throws TemplateException {
            this.checkDateTypeNotUnknown(dateType);
            return new Result(date, dateType, env);
        }

        class Result
        implements TemplateMethodModelEx {
            private final Date date;
            private final int dateType;
            private final Environment env;

            Result(Date date, int dateType, Environment env) {
                this.date = date;
                this.dateType = dateType;
                this.env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                TimeZone tzArg;
                Object adaptedObj;
                iso_BI.this.checkMethodArgCount(args, 1);
                TemplateModel tzArgTM = (TemplateModel)args.get(0);
                if (tzArgTM instanceof AdapterTemplateModel && (adaptedObj = ((AdapterTemplateModel)tzArgTM).getAdaptedObject(class$java$util$TimeZone == null ? (class$java$util$TimeZone = DateBuiltins.class$("java.util.TimeZone")) : class$java$util$TimeZone)) instanceof TimeZone) {
                    tzArg = (TimeZone)adaptedObj;
                } else if (tzArgTM instanceof TemplateScalarModel) {
                    String tzName = EvalUtil.modelToString((TemplateScalarModel)tzArgTM, null, null);
                    try {
                        tzArg = DateUtil.getTimeZone(tzName);
                    }
                    catch (UnrecognizedTimeZoneException e) {
                        throw new _TemplateModelException(new Object[]{"The time zone string specified for ?", iso_BI.this.key, "(...) is not recognized as a valid time zone name: ", new _DelayedJQuote(tzName)});
                    }
                } else {
                    throw MessageUtil.newMethodArgUnexpectedTypeException("?" + iso_BI.this.key, 0, "string or java.util.TimeZone", tzArgTM);
                }
                return new SimpleScalar(DateUtil.dateToISO8601String(this.date, this.dateType != 1, this.dateType != 2, iso_BI.this.showOffset && this.dateType != 2, iso_BI.this.accuracy, tzArg, this.env.getISOBuiltInCalendar()));
            }
        }
    }

    static class iso_tz_BI
    extends AbstractISOBI {
        private final boolean useUTC;

        iso_tz_BI(boolean showOffset, int accuracy, boolean useUTC) {
            super(showOffset, accuracy);
            this.useUTC = useUTC;
        }

        protected TemplateModel calculateResult(Date date, int dateType, Environment env) throws TemplateException {
            this.checkDateTypeNotUnknown(dateType);
            return new SimpleScalar(DateUtil.dateToISO8601String(date, dateType != 1, dateType != 2, this.showOffset && dateType != 2, this.accuracy, this.useUTC ? DateUtil.UTC : env.getTimeZone(), env.getISOBuiltInCalendar()));
        }
    }

    static abstract class AbstractISOBI
    extends DateBuiltin {
        protected final boolean showOffset;
        protected final int accuracy;

        protected AbstractISOBI(boolean showOffset, int accuracy) {
            this.showOffset = showOffset;
            this.accuracy = accuracy;
        }

        protected void checkDateTypeNotUnknown(int dateType) throws TemplateException {
            if (dateType == 0) {
                throw new _MiscTemplateException(new _ErrorDescriptionBuilder(new Object[]{"The value of the following has unknown date type, but ?", this.key, " needs a date value where it's known if it's a date-only, time-only, or date+time value:"}).blame(this.target).tips(MessageUtil.UNKNOWN_DATE_TYPE_ERROR_TIPS));
            }
        }
    }

    private static abstract class DateBuiltin
    extends BuiltIn {
        private DateBuiltin() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateDateModel) {
                TemplateDateModel tdm = (TemplateDateModel)model;
                return this.calculateResult(EvalUtil.modelToDate(tdm, this.target), tdm.getDateType(), env);
            }
            if (model == null) {
                throw InvalidReferenceException.getInstance(this.target, env);
            }
            throw new NonDateException(this.target, model, "date", env);
        }

        protected abstract TemplateModel calculateResult(Date var1, int var2, Environment var3) throws TemplateException;
    }
}

