/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.graph;

import org.jboss.forge.furnace.impl.graph.AddonDependencyEdge;
import org.jboss.forge.furnace.impl.graph.AddonVertex;
import org.jboss.forge.furnace.impl.graph.PrintGraphTraversalListener;
import org.jboss.forge.furnace.versions.Version;
import org.jgrapht.DirectedGraph;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.traverse.DepthFirstIterator;

public abstract class AddonGraph<T extends AddonGraph<T>> {
    public abstract DirectedGraph<AddonVertex, AddonDependencyEdge> getGraph();

    protected AddonVertex getVertex(String name, Version version) {
        AddonVertex result = null;
        for (AddonVertex vertex : this.getGraph().vertexSet()) {
            if (!vertex.getName().equals(name) || version.compareTo((Object)vertex.getVersion()) != 0) continue;
            result = vertex;
            break;
        }
        return result;
    }

    protected AddonVertex getOrCreateVertex(String name, Version version) {
        AddonVertex vertex = this.getVertex(name, version);
        if (vertex == null) {
            vertex = new AddonVertex(name, version);
            this.addLocalVertex(vertex);
        }
        return vertex;
    }

    protected void addLocalVertex(AddonVertex vertex) {
        this.getGraph().addVertex((Object)vertex);
    }

    public String toString() {
        DepthFirstIterator iterator = new DepthFirstIterator(this.getGraph());
        StringBuilder builder = new StringBuilder();
        iterator.addTraversalListener((TraversalListener)new PrintGraphTraversalListener(this.getGraph(), builder));
        while (iterator.hasNext()) {
            iterator.next();
        }
        return builder.toString();
    }
}

