/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.modules.providers;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.forge.furnace.impl.modules.ModuleSpecProvider;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public abstract class AbstractModuleSpecProvider
implements ModuleSpecProvider {
    @Override
    public ModuleSpec get(ModuleLoader loader, ModuleIdentifier id) {
        if (this.getId().equals(id)) {
            ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)id);
            builder.addDependency(DependencySpec.createClassLoaderDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll(), (ClassLoader)AbstractModuleSpecProvider.class.getClassLoader(), this.getPaths()));
            builder.addDependency(DependencySpec.createClassLoaderDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll(), (ClassLoader)ClassLoader.getSystemClassLoader(), this.getPaths()));
            this.configure(loader, builder);
            return builder.create();
        }
        return null;
    }

    protected void configure(ModuleLoader loader, ModuleSpec.Builder builder) {
    }

    protected abstract ModuleIdentifier getId();

    protected abstract Set<String> getPaths();

    private static Set<String> getPathsFrom(String root, File file) {
        String[] children;
        HashSet<String> result = new HashSet<String>();
        for (String name : children = file.list()) {
            File child = new File(file, name);
            if (!child.isDirectory()) continue;
            result.addAll(AbstractModuleSpecProvider.getPathsFrom(root, child));
            String path = child.getAbsolutePath().substring(root.length() + 1);
            result.add(path);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set<String> getLoaderPaths() {
        URL[] urls;
        HashSet<String> result = new HashSet<String>();
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        for (URL url : urls = ((URLClassLoader)loader).getURLs()) {
            try {
                File file = new File(url.toURI());
                if (file.isDirectory()) {
                    result.addAll(AbstractModuleSpecProvider.getPathsFrom(file.getAbsolutePath(), file));
                    continue;
                }
                if (file.isDirectory()) continue;
                JarFile jar = new JarFile(file);
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.indexOf(47) == -1) continue;
                        result.add(name.substring(0, name.lastIndexOf(47)));
                    }
                }
                finally {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Failed loading paths from: [" + url.toString() + "]. Attempting folder discovery");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

