/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntArrayList
extends AbstractIntCollection
implements IntIndexedContainer,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    private static final Object EMPTY = new int[0];
    public int[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public IntArrayList() {
        this(5);
    }

    public IntArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public IntArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public IntArrayList(IntContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void add(int e1, int e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void add(int[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(int ... elements) {
        this.add(elements, 0, elements.length);
    }

    public final int addAll(IntContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (IntCursor cursor : container) {
            this.add(cursor.value);
        }
        return size;
    }

    public final int addAll(Iterable<? extends IntCursor> iterable) {
        int size = 0;
        for (IntCursor intCursor : iterable) {
            this.add(intCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public final void insert(int index, int e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public final int get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public final int set(int index, int e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        int v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public final int remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        int v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0;
        return v;
    }

    @Override
    public final void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, 0);
    }

    @Override
    public final int removeFirstOccurrence(int e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public final int removeLastOccurrence(int e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public final int removeAllOccurrences(int e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = 0;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = 0;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public final boolean contains(int e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public final int indexOf(int e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(int e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            int[] newBuffer = new int[newSize];
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            }
            this.buffer = newBuffer;
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public final int size() {
        return this.elementsCount;
    }

    public final void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public final void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0);
        this.elementsCount = 0;
    }

    public final void release() {
        this.buffer = (int[])EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public final int[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public IntArrayList clone() {
        try {
            IntArrayList cloned = (IntArrayList)super.clone();
            cloned.buffer = (int[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof IntArrayList) {
                IntArrayList other = (IntArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof IntIndexedContainer) {
                IntIndexedContainer other = (IntIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(int[] b1, int[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(IntIndexedContainer b1, IntIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            int o2;
            int o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends IntProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        int[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(IntPredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0;
                    continue;
                }
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends IntPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        int[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static IntArrayList newInstance() {
        return new IntArrayList();
    }

    public static IntArrayList newInstanceWithCapacity(int initialCapacity) {
        return new IntArrayList(initialCapacity);
    }

    public static IntArrayList from(int ... elements) {
        IntArrayList list = new IntArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static IntArrayList from(IntContainer container) {
        return new IntArrayList(container);
    }

    static final class ValueIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int[] buffer;
        private final int size;

        public ValueIterator(int[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected IntCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (IntCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

