/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.xadisk.bridge.server.conversation.ConversationGateway;
import org.xadisk.filesystem.NativeXAFileSystem;

public class PointOfContact
implements Work {
    private final ServerSocket serverSocket;
    private final ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
    private volatile boolean enabled = true;
    private final ConversationGateway conversationGateway;
    private final NativeXAFileSystem xaFileSystem;

    public PointOfContact(NativeXAFileSystem xaFileSystem, int port) throws IOException, WorkException {
        this.serverSocket = this.serverSocketChannel.socket();
        this.serverSocket.bind(new InetSocketAddress(port));
        this.conversationGateway = new ConversationGateway(xaFileSystem);
        this.xaFileSystem = xaFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.xaFileSystem.startWork(this.conversationGateway);
            while (this.enabled) {
                try {
                    SocketChannel clientConverationChannel = this.serverSocketChannel.accept();
                    this.conversationGateway.delegateConversation(clientConverationChannel);
                }
                catch (AsynchronousCloseException asce) {
                    // empty catch block
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.xaFileSystem.notifySystemFailure(t);
        }
        finally {
            this.conversationGateway.release();
            this.closeServerSocket();
        }
    }

    public void release() {
        this.enabled = false;
        this.closeServerSocket();
    }

    private void closeServerSocket() {
        try {
            this.serverSocketChannel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

