/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.server.conversation;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.resource.spi.work.Work;
import org.xadisk.bridge.server.conversation.ConversationContext;
import org.xadisk.filesystem.NativeXAFileSystem;

public class ConversationGateway
implements Work {
    private volatile boolean enabled = true;
    private final Selector selector;
    private ConcurrentLinkedQueue<SocketChannel> channelsToRegister = new ConcurrentLinkedQueue();
    private final NativeXAFileSystem xaFileSystem;

    public ConversationGateway(NativeXAFileSystem xaFileSystem) throws IOException {
        this.xaFileSystem = xaFileSystem;
        this.selector = Selector.open();
    }

    public void delegateConversation(SocketChannel clientChannel) throws IOException, InterruptedException {
        clientChannel.configureBlocking(false);
        this.channelsToRegister.add(clientChannel);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(1000);
            while (this.enabled) {
                SocketChannel newConversationChannel;
                int n = this.selector.select();
                while ((newConversationChannel = this.channelsToRegister.poll()) != null) {
                    ConversationContext context = new ConversationContext(newConversationChannel, this.xaFileSystem);
                    newConversationChannel.register(this.selector, 1, context);
                }
                if (n == 0) continue;
                Set<SelectionKey> selectedReadable = this.selector.selectedKeys();
                for (SelectionKey selectionKey : selectedReadable) {
                    ConversationContext context = (ConversationContext)selectionKey.attachment();
                    SocketChannel channel = context.getConversationChannel();
                    buffer.clear();
                    try {
                        int numRead = channel.read(buffer);
                        if (numRead == -1) {
                            throw new EOFException();
                        }
                        buffer.flip();
                        context.updateWithConversation(buffer);
                    }
                    catch (IOException ioe) {
                        this.closeClientConversation(selectionKey, channel);
                    }
                }
                selectedReadable.clear();
            }
        }
        catch (Throwable t) {
            this.xaFileSystem.notifySystemFailure(t);
        }
        finally {
            this.closeAllClientConversations();
        }
    }

    public void release() {
        this.enabled = false;
        this.selector.wakeup();
    }

    private void closeClientConversation(SelectionKey selectionKey, SocketChannel channel) {
        selectionKey.cancel();
        try {
            channel.socket().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void closeAllClientConversations() {
        Set<SelectionKey> connectedClientKeys = this.selector.keys();
        for (SelectionKey key : connectedClientKeys) {
            try {
                ((SocketChannel)key.channel()).socket().close();
            }
            catch (Throwable t) {}
        }
        try {
            this.selector.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

