/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.io.Serializable;
import org.xadisk.filesystem.TransactionInformation;

public class FileSystemStateChangeEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final boolean isDirectory;
    private final FileSystemEventType eventType;
    private final transient TransactionInformation enqueuingTransaction;

    FileSystemStateChangeEvent(File file, boolean isDirectory, FileSystemEventType eventType, TransactionInformation enqueuingTransaction) {
        this.file = file;
        this.isDirectory = isDirectory;
        this.eventType = eventType;
        this.enqueuingTransaction = enqueuingTransaction;
    }

    public File getFile() {
        return this.file;
    }

    public FileSystemEventType getEventType() {
        return this.eventType;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    TransactionInformation getEnqueuingTransaction() {
        return this.enqueuingTransaction;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileSystemStateChangeEvent) {
            FileSystemStateChangeEvent that = (FileSystemStateChangeEvent)obj;
            return that.file.equals(this.file) && that.eventType.equals((Object)this.eventType) && that.isDirectory == this.isDirectory && that.enqueuingTransaction.equals(this.enqueuingTransaction);
        }
        return false;
    }

    public String toString() {
        return "Event Type : " + this.eventType.name() + " || File Name : " + this.file + " || Is a Directory : " + this.isDirectory + System.getProperty("line.separator");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileSystemEventType {
        MODIFIED(1),
        DELETED(2),
        CREATED(4);

        private final byte byteValue;

        private FileSystemEventType(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte getByteValue() {
            return this.byteValue;
        }

        public static FileSystemEventType getFileSystemEventType(byte byteValue) {
            return FileSystemEventType.values()[byteValue / 2];
        }
    }
}

