/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.xadisk.filesystem.NativeLock;
import org.xadisk.filesystem.TransactionInformation;

public class ResourceDependencyGraph {
    private final ConcurrentHashMap<TransactionInformation, Node> nodes = new ConcurrentHashMap(1000);

    ResourceDependencyGraph() {
    }

    void addDependency(TransactionInformation dependent, NativeLock resource) {
        Node node = new Node(dependent, 0, resource, Thread.currentThread());
        this.nodes.put(dependent, node);
        dependent.setNodeInResourceDependencyGraph(node);
    }

    void removeDependency(TransactionInformation dependent) {
        Node source = dependent.getNodeInResourceDependencyGraph();
        source.setResourceWaitingFor(null);
        this.nodes.remove(dependent);
        dependent.setNodeInResourceDependencyGraph(null);
    }

    public Node[] getNodes() {
        return this.nodes.values().toArray(new Node[0]);
    }

    public Node getNode(TransactionInformation dependent) {
        return this.nodes.get(dependent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        public static final byte INTERRUPTED_DUE_TO_DEADLOCK = 1;
        public static final byte INTERRUPTED_DUE_TO_TIMEOUT = 2;
        private final TransactionInformation id;
        private final ArrayList<Node> neighbors = new ArrayList(10);
        private final Thread threadWaitingForLock;
        private volatile byte interruptCause = 0;
        private final Object interruptFlagLock = new ArrayList(0);
        private int mark;
        private int[] prepostVisit = new int[2];
        private Node parent = null;
        private int nextNeighborToProcess = 0;
        private volatile NativeLock resourceWaitingFor;

        private Node(TransactionInformation id, int defaultMark, NativeLock resourceWaitingFor, Thread threadWaitingForLock) {
            this.id = id;
            this.mark = defaultMark;
            this.resourceWaitingFor = resourceWaitingFor;
            this.threadWaitingForLock = threadWaitingForLock;
        }

        public void addNeighbor(Node n) {
            this.neighbors.add(n);
        }

        public ArrayList<Node> getNeighbors() {
            return this.neighbors;
        }

        public void setMark(int mark) {
            this.mark = mark;
        }

        public int getMark() {
            return this.mark;
        }

        public void setPreVisit(int preVisit) {
            this.prepostVisit[0] = preVisit;
        }

        public void setPostVisit(int postVisit) {
            this.prepostVisit[1] = postVisit;
        }

        public int[] getPrepostVisit() {
            return this.prepostVisit;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public TransactionInformation getId() {
            return this.id;
        }

        public void resetAlgorithmicData() {
            this.mark = 0;
            this.parent = null;
            this.prepostVisit[0] = 0;
            this.prepostVisit[1] = 0;
            this.nextNeighborToProcess = 0;
            this.neighbors.clear();
        }

        public boolean isWaitingForResource() {
            return this.resourceWaitingFor != null;
        }

        public int getNextNeighborToProcess() {
            return this.nextNeighborToProcess;
        }

        public void forwardNextNeighborToProcess() {
            ++this.nextNeighborToProcess;
        }

        void setResourceWaitingFor(NativeLock resourceWaitingFor) {
            this.resourceWaitingFor = resourceWaitingFor;
        }

        public NativeLock getResourceWaitingFor() {
            return this.resourceWaitingFor;
        }

        public Thread getThreadWaitingForLock() {
            return this.threadWaitingForLock;
        }

        public byte getInterruptCause() {
            return this.interruptCause;
        }

        public void setInterruptCause(byte interruptCause) {
            this.interruptCause = interruptCause;
        }

        public Object getInterruptFlagLock() {
            return this.interruptFlagLock;
        }
    }
}

