/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.model.ApplicationReportIndexModel;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.service.ApplicationReportIndexService;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AttachApplicationReportsToIndexRuleProvider
extends WindupRuleProvider {
    public RulePhase getPhase() {
        return RulePhase.POST_REPORT_GENERATION;
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind applicationReportFound = Query.find(ApplicationReportModel.class);
        AddToApplicationIndex addToApplicationIndex = new AddToApplicationIndex();
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationReportFound).perform((Operation)addToApplicationIndex);
    }

    private class AddToApplicationIndex
    extends AbstractIterationOperation<ApplicationReportModel> {
        private AddToApplicationIndex() {
        }

        public void perform(GraphRewrite event, EvaluationContext context, ApplicationReportModel payload) {
            if (payload.getDisplayInApplicationReportIndex() != null && payload.getDisplayInApplicationReportIndex().booleanValue()) {
                ApplicationReportIndexService applicationReportIndexService = new ApplicationReportIndexService(event.getGraphContext());
                ApplicationReportIndexModel index = applicationReportIndexService.getApplicationReportIndexForProjectModel(payload.getProjectModel());
                index.addApplicationReportModel(payload);
            }
        }

        public String toString() {
            return "AddToApplicationIndex";
        }
    }
}

