/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;

public class TechnologyTagService
extends GraphService<TechnologyTagModel> {
    public TechnologyTagService(GraphContext context) {
        super(context, TechnologyTagModel.class);
    }

    public TechnologyTagModel addTagToFileModel(FileModel fileModel, String tagName, TechnologyTagLevel level) {
        FramedGraphQuery q = this.getGraphContext().getQuery().type(TechnologyTagModel.class).has("name", (Object)tagName);
        TechnologyTagModel m = (TechnologyTagModel)super.getUnique((GraphQuery)q);
        if (m == null) {
            m = (TechnologyTagModel)this.create();
            m.setName(tagName);
            m.setLevel(level);
        }
        m.addFileModel(fileModel);
        return m;
    }

    public Iterable<TechnologyTagModel> findTechnologyTagsForFile(FileModel fm) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)fm.asVertex());
        pipeline.in(new String[]{"techTagToFileModel"}).has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"TechnologyTag");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, TechnologyTagModel.class);
    }
}

