/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.matrix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.extensions.matrix.MatrixRunner;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.util.ANSI;

@CommandDefinition(name="matrix", description="do you take the blue pill??")
public class Matrix
implements Command<CommandInvocation> {
    @Option(shortName=104, hasValue=false)
    private boolean help;
    @Option(shortName=97, hasValue=false, defaultValue={"true"})
    private boolean async;
    @Option(shortName=102)
    private File file;
    @Option(shortName=107, defaultValue={"false"})
    private boolean knock;
    @Option
    private String knockText;
    @Option(shortName=115, defaultValue={"3"})
    private int speed;
    @Option(shortName=108, defaultValue={"true"})
    private boolean logo;
    private ExecutorService executorService;
    private MatrixRunner runner;
    private Shell shell;
    private CommandInvocation commandInvocation;
    private List<String> knockLines;
    private InputStream inputStream;

    public Matrix() {
    }

    public Matrix(int speed, boolean async, boolean knock) {
        this.speed = speed;
        this.async = async;
        this.knock = knock;
    }

    public Matrix(InputStream inputStream, List<String> knockLines) {
        this.inputStream = inputStream;
        this.knockLines = knockLines;
        if (knockLines != null) {
            this.knock = true;
        }
        if (inputStream != null) {
            this.logo = true;
        }
    }

    public Matrix(InputStream inputStream, List<String> knockLines, int speed, boolean async) {
        this.inputStream = inputStream;
        this.knockLines = knockLines;
        this.speed = speed;
        this.async = async;
        if (knockLines != null) {
            this.knock = true;
        }
        if (inputStream != null) {
            this.logo = true;
        }
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
        if (this.help) {
            commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("matrix"));
            commandInvocation.getShell().out().flush();
        } else {
            this.shell = commandInvocation.getShell();
            this.commandInvocation = commandInvocation;
            this.shell.out().print(ANSI.saveCursor());
            this.shell.out().print(ANSI.hideCursor());
            this.shell.enableAlternateBuffer();
            this.shell.out().flush();
            this.startMatrix(this.shell);
            this.processOperation();
        }
        return CommandResult.SUCCESS;
    }

    private void startMatrix(Shell shell) {
        this.setupKnock();
        this.setupInput();
        this.runner = new MatrixRunner(shell, this.knockLines, this.inputStream, this.speed, this.async);
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.execute(this.runner);
    }

    public void processOperation() throws IOException, InterruptedException {
        try {
            while (true) {
                CommandOperation commandOperation;
                if ((commandOperation = this.commandInvocation.getInput()).getInputKey().isNumber() && this.runner != null) {
                    this.runner.speed(Integer.parseInt(String.valueOf((char)commandOperation.getInput()[0])));
                }
                if (commandOperation.getInputKey() == Key.a) {
                    if (this.runner == null) continue;
                    this.runner.asynch();
                    continue;
                }
                if (commandOperation.getInputKey() == Key.q) break;
            }
            this.stop();
            return;
        }
        catch (InterruptedException ie) {
            this.stop();
            throw ie;
        }
    }

    private void stop() throws IOException {
        if (this.runner != null) {
            this.runner.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.inputStream = null;
        this.shell.clear();
        this.shell.out().print(ANSI.restoreCursor());
        this.shell.out().print(ANSI.showCursor());
        this.shell.enableMainBuffer();
        this.shell.out().flush();
    }

    private void setupKnock() {
        if (this.knock) {
            if (this.knockText != null) {
                this.knockLines = new ArrayList<String>();
                this.knockLines.add(this.knockText);
            } else {
                this.knockLines = new ArrayList<String>();
                this.knockLines.add("Follow the white rabbit...");
                this.knockLines.add("Knock, knock, " + System.getProperty("user.name") + "...");
            }
        }
    }

    private void setupInput() {
        if (this.logo && this.inputStream == null) {
            if (this.file != null && this.file.isFile()) {
                try {
                    this.inputStream = new FileInputStream(this.file);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else {
                this.inputStream = this.getClass().getClassLoader().getResourceAsStream("aesh_logo.txt");
            }
        }
    }
}

