/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.loader.IncorrectPhaseDependencyException;
import org.jboss.windup.util.exception.WindupException;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class WindupRuleProviderSorter {
    private List<WindupRuleProvider> providers;
    private IdentityHashMap<Class<? extends WindupRuleProvider>, WindupRuleProvider> classToProviderMap = new IdentityHashMap();
    private Map<String, WindupRuleProvider> idToProviderMap = new HashMap<String, WindupRuleProvider>();

    private WindupRuleProviderSorter(List<WindupRuleProvider> providers) {
        this.providers = new ArrayList<WindupRuleProvider>(providers);
        this.initializeLookupCaches();
        this.sort();
    }

    public static List<WindupRuleProvider> sort(List<WindupRuleProvider> providers) {
        WindupRuleProviderSorter sorter = new WindupRuleProviderSorter(providers);
        return sorter.getProviders();
    }

    private List<WindupRuleProvider> getProviders() {
        return this.providers;
    }

    private void initializeLookupCaches() {
        for (WindupRuleProvider provider : this.providers) {
            Class<?> unproxiedClass = this.unwrapType(provider.getClass());
            this.classToProviderMap.put(unproxiedClass, provider);
            this.idToProviderMap.put(provider.getID(), provider);
        }
    }

    private void sort() {
        DefaultDirectedWeightedGraph g = new DefaultDirectedWeightedGraph(DefaultEdge.class);
        for (WindupRuleProvider provider : this.providers) {
            g.addVertex((Object)provider);
        }
        this.sortByPhase();
        this.checkForImproperPhaseRelationships();
        this.addProviderRelationships((DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge>)g);
        this.checkForCycles((DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge>)g);
        ArrayList<WindupRuleProvider> result = new ArrayList<WindupRuleProvider>(this.providers.size());
        TopologicalOrderIterator iterator = new TopologicalOrderIterator((DirectedGraph)g);
        while (iterator.hasNext()) {
            WindupRuleProvider provider = (WindupRuleProvider)iterator.next();
            result.add(provider);
        }
        this.providers = Collections.unmodifiableList(result);
    }

    private void sortByPhase() {
        Collections.sort(this.providers, new Comparator<WindupRuleProvider>(){

            @Override
            public int compare(WindupRuleProvider o1, WindupRuleProvider o2) {
                return o1.getPhase().getPriority() - o2.getPhase().getPriority();
            }
        });
    }

    private void addProviderRelationships(DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge> g) {
        ArrayList previousProviders = new ArrayList();
        ArrayList<WindupRuleProvider> currentProviders = new ArrayList<WindupRuleProvider>();
        RulePhase previousPhase = null;
        for (WindupRuleProvider provider : this.providers) {
            WindupRuleProvider otherProvider;
            RulePhase currentPhase = provider.getPhase();
            if (currentPhase != previousPhase && currentPhase != RulePhase.IMPLICIT) {
                previousProviders.clear();
                previousProviders.addAll(currentProviders);
                currentProviders.clear();
            }
            currentProviders.add(provider);
            for (Class clz : provider.getExecuteAfter()) {
                otherProvider = this.getByClass(clz);
                if (otherProvider == null) {
                    throw new WindupException("Configuration Provider: " + provider.getID() + " is specified to execute after class: " + clz.getCanonicalName() + " but this class could not be found!");
                }
                g.addEdge((Object)otherProvider, (Object)provider);
            }
            for (Class clz : provider.getExecuteBefore()) {
                otherProvider = this.getByClass(clz);
                if (otherProvider == null) {
                    throw new WindupException("Configuration Provider: " + provider.getID() + " is specified to execute before: " + clz.getCanonicalName() + " but this class could not be found!");
                }
                g.addEdge((Object)provider, (Object)otherProvider);
            }
            for (String depID : provider.getExecuteAfterIDs()) {
                otherProvider = this.getByID(depID);
                if (otherProvider == null) {
                    throw new WindupException("Configuration Provider: " + provider.getID() + " is specified to execute after: " + depID + " but this provider could not be found!");
                }
                g.addEdge((Object)otherProvider, (Object)provider);
            }
            for (String depID : provider.getExecuteBeforeIDs()) {
                otherProvider = this.getByID(depID);
                if (otherProvider == null) {
                    throw new WindupException("Configuration Provider: " + provider.getID() + " is specified to execute before: " + depID + " but this provider could not be found!");
                }
                g.addEdge((Object)provider, (Object)otherProvider);
            }
            if (currentPhase != RulePhase.IMPLICIT) {
                for (WindupRuleProvider prevV : previousProviders) {
                    g.addEdge((Object)prevV, (Object)provider);
                }
            }
            previousPhase = currentPhase;
        }
    }

    private void checkForCycles(DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge> g) {
        CycleDetector cycleDetector = new CycleDetector(g);
        if (cycleDetector.detectCycles()) {
            Set cycles = cycleDetector.findCycles();
            StringBuilder errorSB = new StringBuilder();
            for (WindupRuleProvider cycle : cycles) {
                errorSB.append("Found dependency cycle involving: " + cycle.getID() + "\n");
                Set subCycleSet = cycleDetector.findCyclesContainingVertex((Object)cycle);
                for (WindupRuleProvider subCycle : subCycleSet) {
                    errorSB.append("\tSubcycle: " + subCycle.getID() + "\n");
                }
            }
            throw new RuntimeException("Dependency cycles detected: " + errorSB.toString());
        }
    }

    private void checkForImproperPhaseRelationships() {
        for (WindupRuleProvider provider : this.providers) {
            WindupRuleProvider otherProvider;
            RulePhase rulePhase = provider.getPhase();
            if (rulePhase == null) {
                if (provider.getExecuteAfter() != null && !provider.getExecuteAfter().isEmpty() || provider.getExecuteAfterIDs() != null && !provider.getExecuteAfterIDs().isEmpty() || provider.getExecuteBefore() != null && !provider.getExecuteBefore().isEmpty() || provider.getExecuteBeforeIDs() != null && !provider.getExecuteBeforeIDs().isEmpty()) continue;
                throw new IncorrectPhaseDependencyException("Error, rule \"" + provider.getID() + "\" Uses an implicit phase (phase is null) " + " but does not specify any dependencies");
            }
            for (Class classDep : provider.getExecuteAfter()) {
                otherProvider = this.getByClass(classDep);
                if (otherProvider == null || WindupRuleProviderSorter.phaseRelationshipOk(otherProvider, provider)) continue;
                throw new IncorrectPhaseDependencyException("Error, rule \"" + provider.getID() + "\" from phase \"" + rulePhase + "\" is to set to execute after rule \"" + otherProvider.getID() + "\"" + " from phase \"" + otherProvider.getPhase() + "\". Rules must only specify rules " + rulePhase + " or an earlier phase.");
            }
            for (Class classDep : provider.getExecuteBefore()) {
                otherProvider = this.getByClass(classDep);
                if (otherProvider == null || WindupRuleProviderSorter.phaseRelationshipOk(provider, otherProvider)) continue;
                throw new IncorrectPhaseDependencyException("Error, rule \"" + provider.getID() + "\" from phase \"" + rulePhase + "\" is to set to execute before rule \"" + otherProvider.getID() + "\"" + " from phase \"" + otherProvider.getPhase() + "\". Rules must only specify rules " + rulePhase + " or a later phase.");
            }
            for (String idDep : provider.getExecuteAfterIDs()) {
                otherProvider = this.getByID(idDep);
                if (otherProvider == null || WindupRuleProviderSorter.phaseRelationshipOk(otherProvider, provider)) continue;
                throw new IncorrectPhaseDependencyException("Error, rule \"" + provider.getID() + "\" from phase \"" + rulePhase + "\" is to set to execute after rule \"" + otherProvider.getID() + "\"" + " from phase \"" + otherProvider.getPhase() + "\". Rules must only specify rules " + rulePhase + " or an earlier phase.");
            }
            for (String idDep : provider.getExecuteBeforeIDs()) {
                otherProvider = this.getByID(idDep);
                if (otherProvider == null || WindupRuleProviderSorter.phaseRelationshipOk(provider, otherProvider)) continue;
                throw new IncorrectPhaseDependencyException("Error, rule \"" + provider.getID() + "\" from phase \"" + rulePhase + "\" is to set to execute before rule \"" + otherProvider.getID() + "\"" + " from phase \"" + otherProvider.getPhase() + "\". Rules must only specify rules " + rulePhase + " or a later phase.");
            }
        }
    }

    private static boolean phaseRelationshipOk(WindupRuleProvider before, WindupRuleProvider after) {
        RulePhase beforePhase = before.getPhase();
        RulePhase afterPhase = after.getPhase();
        if (beforePhase == RulePhase.IMPLICIT || afterPhase == RulePhase.IMPLICIT) {
            return true;
        }
        return beforePhase.getPriority() <= afterPhase.getPriority();
    }

    private WindupRuleProvider getByClass(Class<? extends WindupRuleProvider> c) {
        return this.classToProviderMap.get(c);
    }

    private WindupRuleProvider getByID(String id) {
        return this.idToProviderMap.get(id);
    }

    private <T> Class<T> unwrapType(Class<T> wrapped) {
        return Proxies.unwrapProxyTypes(wrapped, (ClassLoader[])new ClassLoader[0]);
    }
}

